/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.ddssutils.world;

import me.dierke9.ddssutils.world.util.OpenSimplexNoise;
import net.minecraft.world.World;

public class NoiseProvider {
    public static OpenSimplexNoise NOISE;
    public static NoiseOctave octave0;
    public static NoiseOctave octave1;
    public static NoiseOctave octave2;
    private static boolean initialised;

    public static boolean init() {
        return initialised;
    }

    public static boolean init(World worldIn) {
        if (initialised) {
            return true;
        }
        initialised = true;
        NOISE = new OpenSimplexNoise(worldIn.func_72905_C());
        octave0 = new NoiseOctave(NOISE, 0.022f, 28.0, 6.0);
        octave1 = new NoiseOctave(NOISE, 0.062f, 7.0, 4.0, -0.35);
        octave2 = new NoiseOctave(NOISE, 0.04f, 3.0, 2.0);
        return true;
    }

    public static NoiseOctave[] getOctaves() {
        return new NoiseOctave[]{octave0, octave1, octave2};
    }

    static {
        initialised = false;
    }

    public static class NoiseOctave {
        private final double scale;
        private final OpenSimplexNoise simplex;
        public final double megaScale;
        public final double offset;
        public final double minorScale;

        public NoiseOctave(OpenSimplexNoise noiseEntry, double stretch) {
            this(noiseEntry, stretch, 1.0, 1.0);
        }

        public NoiseOctave(OpenSimplexNoise noiseEntry, double stretch, double megaScale, double minorScale) {
            this(noiseEntry, stretch, megaScale, minorScale, 0.0);
        }

        public NoiseOctave(OpenSimplexNoise noiseEntry, double stretch, double megaScale, double minorScale, double offset) {
            this.simplex = noiseEntry;
            this.scale = stretch;
            this.megaScale = megaScale;
            this.minorScale = minorScale;
            this.offset = offset;
        }

        public double eval2d(double x, double y) {
            double d = this.offset + this.simplex.eval(x * this.scale, y * this.scale);
            return d > 0.0 ? d * this.megaScale : d * this.minorScale;
        }

        public long getSeed() {
            return this.simplex.getSeed();
        }
    }
}

