/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.color;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.color.ColorUtil;
import mezz.jei.util.Translator;

public class ColorNamer {
    private final ImmutableMap<Color, String> colorNames;

    public ColorNamer(ImmutableMap<Color, String> colorNames) {
        this.colorNames = colorNames;
    }

    public Collection<String> getColorNames(Iterable<Color> colors, boolean lowercase) {
        LinkedHashSet<String> allColorNames = new LinkedHashSet<String>();
        for (Color color : colors) {
            String colorName = this.getClosestColorName(color);
            if (colorName == null) continue;
            if (lowercase) {
                allColorNames.add(Translator.toLowercaseWithLocale(colorName));
                continue;
            }
            allColorNames.add(colorName);
        }
        return allColorNames;
    }

    @Nullable
    private String getClosestColorName(Color color) {
        if (this.colorNames.isEmpty()) {
            return null;
        }
        String closestColorName = null;
        Double closestColorDistance = Double.MAX_VALUE;
        for (Map.Entry entry : this.colorNames.entrySet()) {
            Color namedColor = (Color)entry.getKey();
            Double distance = ColorUtil.slowPerceptualColorDistanceSquared(namedColor, color);
            if (!(distance < closestColorDistance)) continue;
            closestColorDistance = distance;
            closestColorName = (String)entry.getValue();
        }
        return closestColorName;
    }
}

