/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.tile;

import com.codetaylor.mc.artisanworktables.lib.RoundRobinHelper;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.items.IItemHandler;

public class RoundRobinGhostStackHandler
implements IItemHandler {
    private final TileEntityBase tile;
    private final IItemHandler stackHandler;
    private final IItemHandler ghostStackHandler;

    public RoundRobinGhostStackHandler(TileEntityBase tile, IItemHandler stackHandler, IItemHandler ghostStackHandler) {
        this.tile = tile;
        this.stackHandler = stackHandler;
        this.ghostStackHandler = ghostStackHandler;
    }

    public int getSlots() {
        return this.stackHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stackHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack itemStack, boolean simulate) {
        IItemHandler stackHandler = simulate ? RoundRobinHelper.copyItemHandler(this.stackHandler) : this.stackHandler;
        IItemHandler ghostStackHandler = this.ghostStackHandler;
        ItemStack safeItemStack = itemStack.func_77946_l();
        int count = safeItemStack.func_190916_E();
        for (int i = 0; i < count; ++i) {
            List<Tuple> list = RoundRobinHelper.getSortedIndices(safeItemStack, stackHandler, ghostStackHandler);
            if (list.isEmpty()) {
                return safeItemStack;
            }
            ItemStack copy = safeItemStack.func_77946_l();
            copy.func_190920_e(1);
            int index = (Integer)list.get(0).func_76341_a();
            ItemStack result = stackHandler.insertItem(index, copy, simulate);
            if (!result.func_190926_b()) {
                return safeItemStack;
            }
            safeItemStack.func_190918_g(1);
        }
        return safeItemStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.stackHandler.getSlotLimit(slot);
    }
}

