/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker;

import com.codetaylor.mc.artisanworktables.api.internal.recipe.ICraftingMatrixStackHandler;
import com.codetaylor.mc.artisanworktables.modules.worktables.gui.AWContainer;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntityBase;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.spi.TileEntitySecondaryInputBase;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public final class ZSRecipeExport {
    public static String getExportString(AWContainer container, TileEntityBase tileEntity, boolean shaped) {
        ICraftingMatrixStackHandler craftingMatrixHandler = tileEntity.getCraftingMatrixHandler();
        int width = craftingMatrixHandler.getWidth();
        int height = craftingMatrixHandler.getHeight();
        ItemStackHandler resultHandler = tileEntity.getResultHandler();
        ItemStackHandler secondaryOutputHandler = tileEntity.getSecondaryOutputHandler();
        FluidTank tank = tileEntity.getTank();
        StringBuilder out = new StringBuilder();
        out.append("RecipeBuilder.get(\"").append(tileEntity.getType().func_176610_l()).append("\")\n");
        if (shaped) {
            int y;
            int x;
            int i;
            out.append("  .setShaped([\n");
            int xMin = width;
            int xMax = 0;
            int yMin = height;
            int yMax = 0;
            for (int i2 = container.slotIndexCraftingMatrixStart; i2 <= container.slotIndexCraftingMatrixEnd; ++i2) {
                int x2 = (i2 - container.slotIndexCraftingMatrixStart) % width;
                int y2 = (i2 - container.slotIndexCraftingMatrixStart) / width;
                if (!container.func_75139_a(i2).func_75216_d()) continue;
                if (x2 < xMin) {
                    xMin = x2;
                }
                if (x2 > xMax) {
                    xMax = x2;
                }
                if (y2 < yMin) {
                    yMin = y2;
                }
                if (y2 <= yMax) continue;
                yMax = y2;
            }
            int actualWidth = xMax - xMin + 1;
            int actualHeight = yMax - yMin + 1;
            ItemStack[] remappedGrid = new ItemStack[actualWidth * actualHeight];
            for (i = container.slotIndexCraftingMatrixStart; i <= container.slotIndexCraftingMatrixEnd; ++i) {
                x = (i - container.slotIndexCraftingMatrixStart) % width;
                y = (i - container.slotIndexCraftingMatrixStart) / height;
                if (x < xMin || x > xMax || y < yMin || y > yMax) continue;
                Slot slot = container.func_75139_a(i);
                ItemStack stack = slot.func_75211_c();
                int xMapped = x - xMin;
                int yMapped = y - yMin;
                remappedGrid[xMapped + yMapped * actualWidth] = stack;
            }
            for (i = 0; i < remappedGrid.length; ++i) {
                x = i % actualWidth;
                y = i / actualWidth;
                if (x == 0) {
                    out.append("    [");
                }
                int containerIndex = container.slotIndexCraftingMatrixStart + (x + xMin) + (y + yMin) * width;
                String oreDict = (String)tileEntity.oreDictMap.func_76041_a(containerIndex);
                ItemStack stackInSlot = remappedGrid[i];
                if (oreDict == null) {
                    ZSRecipeExport.getItemString(stackInSlot, out, true, false, false);
                } else {
                    ZSRecipeExport.getItemStringOredict(oreDict, stackInSlot, out, true);
                }
                if (i == remappedGrid.length - 1) {
                    out.append("]])\n");
                    continue;
                }
                if (x == actualWidth - 1) {
                    out.append("],\n");
                    continue;
                }
                out.append(", ");
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = container.slotIndexCraftingMatrixStart; i <= container.slotIndexCraftingMatrixEnd; ++i) {
                String oreDict = (String)tileEntity.oreDictMap.func_76041_a(i);
                ItemStack stackInSlot = container.func_75139_a(i).func_75211_c();
                if (stackInSlot.func_190926_b()) continue;
                StringBuilder builder = new StringBuilder();
                if (oreDict == null) {
                    ZSRecipeExport.getItemString(stackInSlot, builder, true, false, false);
                } else {
                    ZSRecipeExport.getItemStringOredict(oreDict, stackInSlot, builder, true);
                }
                list.add(builder.toString());
            }
            out.append("  .setShapeless([").append(String.join((CharSequence)", ", list)).append("])\n");
        }
        if (tank.getFluidAmount() > 0 && tank.getFluid() != null) {
            FluidStack fluid = tank.getFluid();
            String name = fluid.getFluid().getName();
            out.append("  .setFluid(<").append("liquid:").append(name).append("> * ").append(fluid.amount).append(")\n");
        }
        if (tileEntity instanceof TileEntitySecondaryInputBase) {
            int i;
            IItemHandlerModifiable secondaryIngredientHandler = ((TileEntitySecondaryInputBase)tileEntity).getSecondaryIngredientHandler();
            int total = 0;
            int count = 0;
            for (i = 0; i < secondaryIngredientHandler.getSlots(); ++i) {
                if (secondaryIngredientHandler.getStackInSlot(i).func_190926_b()) continue;
                ++total;
            }
            if (total > 0) {
                out.append("  .setSecondaryIngredients([");
                for (i = container.slotIndexSecondaryInputStart; i <= container.slotIndexSecondaryInputEnd; ++i) {
                    String oreDict = (String)tileEntity.oreDictMap.func_76041_a(i);
                    ItemStack stackInSlot = container.func_75139_a(i).func_75211_c();
                    if (stackInSlot.func_190926_b()) continue;
                    StringBuilder builder = new StringBuilder();
                    if (oreDict == null) {
                        ZSRecipeExport.getItemString(stackInSlot, builder, false, false, false);
                    } else {
                        ZSRecipeExport.getItemStringOredict(oreDict, stackInSlot, builder, false);
                    }
                    out.append(builder.toString());
                    out.append(++count == total ? "" : ", ");
                }
                out.append("])\n");
            }
        }
        for (int i = container.slotIndexToolsStart; i <= container.slotIndexToolsEnd; ++i) {
            String oreDict = (String)tileEntity.oreDictMap.func_76041_a(i);
            ItemStack stackInSlot = container.func_75139_a(i).func_75211_c();
            if (stackInSlot.func_190926_b()) continue;
            out.append("  .addTool(");
            StringBuilder builder = new StringBuilder();
            if (oreDict == null) {
                ZSRecipeExport.getItemString(stackInSlot, builder, true, false, false);
            } else {
                ZSRecipeExport.getItemStringOredict(oreDict, stackInSlot, builder, true);
            }
            out.append(builder.toString());
            out.append(", 1)\n");
        }
        ItemStack stackInSlot = resultHandler.getStackInSlot(0);
        out.append("  .addOutput(");
        ZSRecipeExport.getItemString(stackInSlot, out, false, false, false);
        out.append(")\n");
        int slot = 0;
        for (int i = 0; i < secondaryOutputHandler.getSlots(); ++i) {
            ItemStack stackInSlot2 = secondaryOutputHandler.getStackInSlot(i);
            if (stackInSlot2.func_190926_b()) continue;
            if (slot == 0) {
                ++slot;
                out.append("  .setExtraOutputOne(");
                ZSRecipeExport.getItemString(stackInSlot2, out, false, false, false);
                out.append(", 1.0)\n");
                continue;
            }
            if (slot == 1) {
                ++slot;
                out.append("  .setExtraOutputTwo(");
                ZSRecipeExport.getItemString(stackInSlot2, out, false, false, false);
                out.append(", 1.0)\n");
                continue;
            }
            if (slot != 2) continue;
            ++slot;
            out.append("  .setExtraOutputThree(");
            ZSRecipeExport.getItemString(stackInSlot2, out, false, false, false);
            out.append(", 1.0)\n");
        }
        out.append("  .create();");
        return out.toString();
    }

    private static StringBuilder getItemString(ItemStack itemStack, StringBuilder out, boolean ignoreCount, boolean wildcard, boolean ignoreNbt) {
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName == null || itemStack.func_190926_b()) {
            out.append("null");
        } else {
            String nbt;
            out.append("<").append(registryName.func_110624_b()).append(":").append(registryName.func_110623_a());
            if (wildcard) {
                out.append(":*");
            } else if (itemStack.func_77960_j() > 0) {
                out.append(":").append(itemStack.func_77960_j());
            }
            out.append(">");
            if (!ignoreNbt && itemStack.func_77942_o() && (nbt = Objects.requireNonNull(NBTConverter.from((NBTBase)itemStack.func_77978_p(), (boolean)false)).toString()).length() > 0) {
                out.append(".withTag(").append(nbt).append(")");
            }
            if (!ignoreCount && itemStack.func_190916_E() > 1) {
                out.append(" * ").append(itemStack.func_190916_E());
            }
        }
        return out;
    }

    private static StringBuilder getItemStringOredict(String oreDict, ItemStack itemStack, StringBuilder out, boolean ignoreCount) {
        out.append("<ore:").append(oreDict).append(">");
        if (!ignoreCount && itemStack.func_190916_E() > 1) {
            out.append(" * ").append(itemStack.func_190916_E());
        }
        return out;
    }

    private ZSRecipeExport() {
    }
}

