/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables;

import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumTier;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.athenaeum.util.ArrayHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="artisanworktables", name="artisanworktables/module.Worktables")
public class ModuleWorktablesConfig {
    @Config.Comment(value={"Tables in this list will allow crafting any of the vanilla recipes.", "Table id format is (type):(tier)", "By default, all tables are allowed."})
    public static String[] ENABLE_VANILLA_CRAFTING;
    @Config.Comment(value={"Recipes in this list will not be allowed to be crafted in any table.", "Format is (domain):(path)", "Example: minecraft:chest"})
    public static String[] VANILLA_CRAFTING_BLACKLIST;
    @Config.Comment(value={"Set to true to enable log warnings for duplicate recipe names.", "If you're using a lot of your own recipe names, you can enable this", "from time to time to check that you haven't accidentally used the", "same name twice."})
    public static boolean ENABLE_DUPLICATE_RECIPE_NAME_WARNINGS;
    @Config.Comment(value={"Set to false to disable worktables."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKTABLES;
    @Config.Comment(value={"Set to false to disable workstations."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKSTATIONS;
    @Config.Comment(value={"Set to false to disable workshops."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_WORKSHOPS;
    @Config.Comment(value={"Set to false to disable the joined tabs for worktables."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_TABS_WORKTABLES;
    @Config.Comment(value={"Set to false to disable the joined tabs for workstations."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_TABS_WORKSTATIONS;
    @Config.Comment(value={"Set to false to disable the joined tabs for workshops."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_TABS_WORKSHOPS;
    @Config.Comment(value={"Set to false to disable the slot-locking feature for worktables."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_SLOT_LOCKING_WORKTABLES;
    @Config.Comment(value={"Set to false to disable the slot-locking feature for workstations."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_SLOT_LOCKING_WORKSTATIONS;
    @Config.Comment(value={"Set to false to disable the slot-locking feature for workshops."})
    @Config.RequiresMcRestart
    public static boolean ENABLE_SLOT_LOCKING_WORKSHOPS;
    @Config.Comment(value={"Set to false to selectively disable a table type across all table tiers."})
    public static Map<String, Boolean> ENABLE_TABLE_TYPE;
    @Config.Comment(value={"Worktable harvest tool: pickaxe, axe, shovel"})
    @Config.RequiresMcRestart
    public static Map<String, String> HARVEST_TOOL_WORKTABLE;
    @Config.Comment(value={"Workstation harvest tool: pickaxe, axe, shovel"})
    @Config.RequiresMcRestart
    public static Map<String, String> HARVEST_TOOL_WORKSTATION;
    @Config.Comment(value={"Workshop harvest tool: pickaxe, axe, shovel"})
    @Config.RequiresMcRestart
    public static Map<String, String> HARVEST_TOOL_WORKSHOP;
    @Config.Comment(value={"If set to true, crafting tools must have sufficient durability remaining to perform the craft.", "If set to false, this restriction is ignored."})
    public static boolean RESTRICT_CRAFT_MINIMUM_DURABILITY;
    @Config.Comment(value={"Worktable fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKTABLE;
    @Config.Comment(value={"Workstation fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKSTATION;
    @Config.Comment(value={"Workshop fluid capacity (milli-buckets)."})
    @Config.RequiresMcRestart
    public static Map<String, Integer> FLUID_CAPACITY_WORKSHOP;
    public static Client CLIENT;
    public static Pattern PATTERN;

    public static boolean isVanillaCraftingEnabledFor(EnumType type, EnumTier tier) {
        String key = type.func_176610_l() + ":" + tier.getName();
        return ArrayHelper.contains((Object[])ENABLE_VANILLA_CRAFTING, (Object)key);
    }

    public static boolean isRecipeBlacklisted(ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        return ArrayHelper.contains((Object[])VANILLA_CRAFTING_BLACKLIST, (Object)resourceLocation.toString());
    }

    public static boolean isTierEnabled(EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return ENABLE_WORKTABLES;
            }
            case WORKSTATION: {
                return ENABLE_WORKSTATIONS;
            }
            case WORKSHOP: {
                return ENABLE_WORKSHOPS;
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    public static boolean allowSlotLockingForTier(EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return ENABLE_SLOT_LOCKING_WORKTABLES;
            }
            case WORKSTATION: {
                return ENABLE_SLOT_LOCKING_WORKSTATIONS;
            }
            case WORKSHOP: {
                return ENABLE_SLOT_LOCKING_WORKSHOPS;
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    public static boolean isTypeEnabled(EnumType type) {
        return ENABLE_TABLE_TYPE.get(type.func_176610_l());
    }

    public static boolean patternSlotsEnabledForTier(EnumTier tier) {
        switch (tier) {
            case WORKTABLE: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKTABLES;
            }
            case WORKSTATION: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKSTATIONS;
            }
            case WORKSHOP: {
                return ModuleWorktablesConfig.PATTERN.ENABLE_PATTERN_CREATION_FOR_WORKSHOPS;
            }
        }
        throw new IllegalArgumentException("Unknown tier: " + (Object)((Object)tier));
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        EnumTier[] enumTierArray = EnumTier.values();
        int n = enumTierArray.length;
        for (int i = 0; i < n; ++i) {
            EnumTier tier = enumTierArray[i];
            for (EnumType type : EnumType.values()) {
                list.add(type.func_176610_l() + ":" + tier.getName());
            }
        }
        Collections.sort(list);
        ENABLE_VANILLA_CRAFTING = list.toArray(new String[0]);
        VANILLA_CRAFTING_BLACKLIST = new String[0];
        ENABLE_DUPLICATE_RECIPE_NAME_WARNINGS = false;
        ENABLE_WORKTABLES = true;
        ENABLE_WORKSTATIONS = true;
        ENABLE_WORKSHOPS = true;
        ENABLE_TABS_WORKTABLES = true;
        ENABLE_TABS_WORKSTATIONS = true;
        ENABLE_TABS_WORKSHOPS = true;
        ENABLE_SLOT_LOCKING_WORKTABLES = false;
        ENABLE_SLOT_LOCKING_WORKSTATIONS = true;
        ENABLE_SLOT_LOCKING_WORKSHOPS = true;
        ENABLE_TABLE_TYPE = new HashMap<String, Boolean>();
        for (EnumType type : EnumType.values()) {
            ENABLE_TABLE_TYPE.put(type.func_176610_l(), true);
        }
        HARVEST_TOOL_WORKTABLE = new TreeMap<String, String>();
        HARVEST_TOOL_WORKSTATION = new TreeMap<String, String>();
        HARVEST_TOOL_WORKSHOP = new TreeMap<String, String>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            HARVEST_TOOL_WORKTABLE.put(name, "pickaxe");
            HARVEST_TOOL_WORKSTATION.put(name, "pickaxe");
            HARVEST_TOOL_WORKSHOP.put(name, "pickaxe");
        }
        RESTRICT_CRAFT_MINIMUM_DURABILITY = true;
        FLUID_CAPACITY_WORKTABLE = new TreeMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKTABLE.put(name, 4000);
        }
        FLUID_CAPACITY_WORKSTATION = new TreeMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKSTATION.put(name, 8000);
        }
        FLUID_CAPACITY_WORKSHOP = new TreeMap<String, Integer>();
        for (String name : ArtisanAPI.getWorktableNames()) {
            FLUID_CAPACITY_WORKSHOP.put(name, 16000);
        }
        CLIENT = new Client();
        PATTERN = new Pattern();
    }

    @Mod.EventBusSubscriber(modid="artisanworktables")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("artisanworktables")) {
                ConfigManager.sync((String)"artisanworktables", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Pattern {
        @Config.Comment(value={"Set to false to prevent players from sneak-clicking to clear the patterns.", "This is useful if you want to provide your own method for clearing patterns."})
        public boolean ENABLE_SNEAK_CLICK_TO_CLEAR = true;
        @Config.Comment(value={"Set to false to disable pattern creation for worktables."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKTABLES = true;
        @Config.Comment(value={"Set to false to disable pattern creation for workstations."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKSTATIONS = true;
        @Config.Comment(value={"Set to false to disable pattern creation for workshops."})
        public boolean ENABLE_PATTERN_CREATION_FOR_WORKSHOPS = true;
        @Config.Comment(value={"By default, patterns can be created from recipes that require player specific requirements to craft.", "ie. xp, gamestages, ftgu, reskillable", "Set to false to disable."})
        public boolean ENABLE_PATTERN_CREATION_FOR_RECIPES_WITH_REQUIREMENTS = true;
    }

    public static class Client {
        @Config.Comment(value={"Here you can change the gui text highlight color. (Hexadecimal)"})
        public Map<String, String> TEXT_HIGHLIGHT_COLOR = new TreeMap<String, String>();
        @Config.Comment(value={"Here you can change the gui fluid tank overlay color. (Hexadecimal)"})
        public Map<String, String> FLUID_TANK_OVERLAY_COLOR = new TreeMap<String, String>();
        @Config.Comment(value={"Here you can change the background color of the crafting grid slots,", "tool slots, secondary input slots, and extra output slots. (Hexadecimal)", "Set to 'off' to use existing background."})
        public Map<String, String> SLOT_BACKGROUND_COLOR = new TreeMap<String, String>();
        @Config.Comment(value={"Here you can change the background color of the fluid tank. (Hexadecimal)", "Set to 'off' to use existing background."})
        public Map<String, String> FLUID_TANK_BACKGROUND_COLOR = new TreeMap<String, String>();
        @Config.Comment(value={"Here you can change the background color of the main output slot. (Hexadecimal)", "Set to 'off' to use existing background."})
        public Map<String, String> MAIN_OUTPUT_SLOT_BACKGROUND_COLOR = new TreeMap<String, String>();
        @Config.Comment(value={"Here you can change the background color of the player's inventory slots. (Hexadecimal)", "Set to 'off' to use existing background."})
        public Map<String, String> PLAYER_INVENTORY_SLOT_BACKGROUND_COLOR = new TreeMap<String, String>();

        Client() {
            String hex;
            Color color;
            List<String> worktableNames = ArtisanAPI.getWorktableNames();
            for (String name : worktableNames) {
                color = new Color(EnumType.fromName(name).getTextOutlineColor());
                hex = String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                this.TEXT_HIGHLIGHT_COLOR.put(name, hex);
            }
            for (String name : worktableNames) {
                color = new Color(EnumType.fromName(name).getTextOutlineColor());
                hex = String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                this.FLUID_TANK_OVERLAY_COLOR.put(name, hex);
            }
            for (String name : worktableNames) {
                this.SLOT_BACKGROUND_COLOR.put(name, "off");
            }
            for (String name : worktableNames) {
                this.FLUID_TANK_BACKGROUND_COLOR.put(name, "off");
            }
            for (String name : worktableNames) {
                this.MAIN_OUTPUT_SLOT_BACKGROUND_COLOR.put(name, "off");
            }
            for (String name : worktableNames) {
                this.PLAYER_INVENTORY_SLOT_BACKGROUND_COLOR.put(name, "off");
            }
        }

        public int getTextHighlightColor(String name) {
            return Integer.decode("0x" + this.TEXT_HIGHLIGHT_COLOR.get(name));
        }

        public int getFluidTankOverlayColor(String name) {
            return Integer.decode("0x" + this.FLUID_TANK_OVERLAY_COLOR.get(name));
        }

        private Integer getColorOrNull(Map<String, String> map, String name) {
            String s = map.get(name);
            if ("off".equals(s)) {
                return null;
            }
            return Integer.decode("0x" + s);
        }

        @Nullable
        public Integer getCraftingGridSlotBackgroundColor(String name) {
            return this.getColorOrNull(this.SLOT_BACKGROUND_COLOR, name);
        }

        @Nullable
        public Integer getFluidTankBackgroundColor(String name) {
            return this.getColorOrNull(this.FLUID_TANK_BACKGROUND_COLOR, name);
        }

        @Nullable
        public Integer getMainOutputSlotBackgroundColor(String name) {
            return this.getColorOrNull(this.MAIN_OUTPUT_SLOT_BACKGROUND_COLOR, name);
        }

        @Nullable
        public Integer getPlayerInventorySlotBackgroundColor(String name) {
            return this.getColorOrNull(this.PLAYER_INVENTORY_SLOT_BACKGROUND_COLOR, name);
        }
    }
}

