/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.modules.worktables;

import com.codetaylor.mc.artisanworktables.ModArtisanWorktables;
import com.codetaylor.mc.artisanworktables.api.ArtisanAPI;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IArtisanIngredient;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeBuilderCopyStrategy;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.IRecipeBuilderCopyStrategyProvider;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.pattern.IItemDesignPattern;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.RecipeBuilder;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementBuilderSupplier;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementContextSupplier;
import com.codetaylor.mc.artisanworktables.modules.worktables.ModuleWorktablesConfig;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockTabIcon;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorkstation;
import com.codetaylor.mc.artisanworktables.modules.worktables.block.BlockWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.craftingtweaks.CraftingTweaksPlugin;
import com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.CTRecipeAdditionQueue;
import com.codetaylor.mc.artisanworktables.modules.worktables.item.ItemDesignPattern;
import com.codetaylor.mc.artisanworktables.modules.worktables.item.ItemDesignPatternBakedModel;
import com.codetaylor.mc.artisanworktables.modules.worktables.item.ItemDesignPatternMeshDefinition;
import com.codetaylor.mc.artisanworktables.modules.worktables.item.ItemWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CSPacketWorktableClear;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CSPacketWorktableCreativeToggle;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CSPacketWorktableLockedModeToggle;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CSPacketWorktableTab;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.CSPacketWorktableTankDestroyFluid;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.SCPacketWorktableContainerJoinedBlockBreak;
import com.codetaylor.mc.artisanworktables.modules.worktables.network.SCPacketWorktableFluidUpdate;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.IRecipeAdditionQueue;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.RecipeAdditionQueue;
import com.codetaylor.mc.artisanworktables.modules.worktables.recipe.RecipeBuilderInternal;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workshop.TileEntityWorkshop;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workshop.TileEntityWorkshopDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workshop.TileEntityWorkshopMage;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workstation.TileEntityWorkstation;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workstation.TileEntityWorkstationDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.workstation.TileEntityWorkstationMage;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.worktable.TileEntityWorktable;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.worktable.TileEntityWorktableDesigner;
import com.codetaylor.mc.artisanworktables.modules.worktables.tile.worktable.TileEntityWorktableMage;
import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketRegistry;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.athenaeum.util.Injector;
import com.codetaylor.mc.athenaeum.util.ModelRegistrationHelper;
import crafttweaker.api.recipes.ICraftingRecipe;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleWorktables
extends ModuleBase {
    public static final String MOD_NAME = "Artisan Worktables";
    public static final String MOD_ID = "artisanworktables";
    public static final CreativeTabs CREATIVE_TAB = ModArtisanWorktables.CREATIVE_TAB;
    public static final Logger LOG = LogManager.getLogger((String)"artisanworktables");
    public static IPacketService PACKET_SERVICE;
    public static IRecipeAdditionQueue RECIPE_ADDITION_QUEUE;

    public ModuleWorktables() {
        super(0, MOD_ID);
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PACKET_SERVICE = this.enableNetwork();
        this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.IZenRecipeBuilder");
        this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.artisanworktables.modules.worktables.integration.crafttweaker.builder.copy.IZenRecipeBuilderCopyStrategy");
        this.registerIntegrationPlugin("jei", "com.codetaylor.mc.artisanworktables.modules.worktables.integration.jei.PluginJEI");
    }

    public void onConstructionEvent(FMLConstructionEvent event) {
        this.injectAPI();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            RECIPE_ADDITION_QUEUE = new CTRecipeAdditionQueue();
            MinecraftForge.EVENT_BUS.register((Object)RECIPE_ADDITION_QUEUE);
        } else {
            RECIPE_ADDITION_QUEUE = new RecipeAdditionQueue();
            MinecraftForge.EVENT_BUS.register((Object)RECIPE_ADDITION_QUEUE);
        }
        super.onConstructionEvent(event);
    }

    public void onInitializationEvent(FMLInitializationEvent event) {
        super.onInitializationEvent(event);
        if (Loader.isModLoaded((String)"craftingtweaks")) {
            CraftingTweaksPlugin.init();
        }
    }

    @SubscribeEvent
    public void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "requirement_context_supplier")).setType(RequirementContextSupplier.class).create();
        new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "requirement_builder_supplier")).setType(RequirementBuilderSupplier.class).create();
        new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "recipe_registry")).setType(RecipeRegistry.class).create();
    }

    @SubscribeEvent
    public void onRegisterRecipeRegistryEvent(RegistryEvent.Register<RecipeRegistry> event) {
        IForgeRegistry registry = event.getRegistry();
        for (String name : ArtisanAPI.getWorktableNames()) {
            registry.register((IForgeRegistryEntry)new RecipeRegistry(MOD_ID, name));
        }
    }

    public void onNetworkRegister(IPacketRegistry registry) {
        registry.register(CSPacketWorktableTab.class, CSPacketWorktableTab.class, Side.SERVER);
        registry.register(CSPacketWorktableTankDestroyFluid.class, CSPacketWorktableTankDestroyFluid.class, Side.SERVER);
        registry.register(CSPacketWorktableClear.class, CSPacketWorktableClear.class, Side.SERVER);
        registry.register(CSPacketWorktableCreativeToggle.class, CSPacketWorktableCreativeToggle.class, Side.SERVER);
        registry.register(CSPacketWorktableLockedModeToggle.class, CSPacketWorktableLockedModeToggle.class, Side.SERVER);
        registry.register(SCPacketWorktableFluidUpdate.class, SCPacketWorktableFluidUpdate.class, Side.CLIENT);
        registry.register(SCPacketWorktableContainerJoinedBlockBreak.class, SCPacketWorktableContainerJoinedBlockBreak.class, Side.CLIENT);
    }

    public void onRegister(Registry registry) {
        registry.registerBlockWithItem(Blocks.TAB_ICON, "tab_icon");
        if (ModuleWorktablesConfig.ENABLE_WORKTABLES) {
            registry.registerBlock((Block)Blocks.WORKTABLE, (ItemBlock)new ItemWorktable(Blocks.WORKTABLE), "worktable");
            registry.registerTileEntities(new Class[]{TileEntityWorktable.class, TileEntityWorktableMage.class, TileEntityWorktableDesigner.class});
        }
        if (ModuleWorktablesConfig.ENABLE_WORKSTATIONS) {
            registry.registerBlock((Block)Blocks.WORKSTATION, (ItemBlock)new ItemWorktable(Blocks.WORKSTATION), "workstation");
            registry.registerTileEntities(new Class[]{TileEntityWorkstation.class, TileEntityWorkstationMage.class, TileEntityWorkstationDesigner.class});
        }
        if (ModuleWorktablesConfig.ENABLE_WORKSHOPS) {
            registry.registerBlock((Block)Blocks.WORKSHOP, (ItemBlock)new ItemWorktable(Blocks.WORKSHOP), "workshop");
            registry.registerTileEntities(new Class[]{TileEntityWorkshop.class, TileEntityWorkshopMage.class, TileEntityWorkshopDesigner.class});
        }
        registry.registerItem((Item)Items.DESIGN_PATTERN, "design_pattern");
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        registry.registerClientModelRegistrationStrategy(() -> ModelRegistrationHelper.registerBlockItemModels((Block[])new Block[]{Blocks.TAB_ICON}));
        if (ModuleWorktablesConfig.ENABLE_WORKTABLES) {
            registry.registerClientModelRegistrationStrategy(Blocks.WORKTABLE.getModelRegistrationStrategy());
        }
        if (ModuleWorktablesConfig.ENABLE_WORKSTATIONS) {
            registry.registerClientModelRegistrationStrategy(Blocks.WORKSTATION.getModelRegistrationStrategy());
        }
        if (ModuleWorktablesConfig.ENABLE_WORKSHOPS) {
            registry.registerClientModelRegistrationStrategy(Blocks.WORKSHOP.getModelRegistrationStrategy());
        }
        registry.registerClientModelRegistrationStrategy(() -> {
            ModelBakery.registerItemVariants((Item)Items.DESIGN_PATTERN, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(MOD_ID, "design_pattern_blank")});
            ModelBakery.registerItemVariants((Item)Items.DESIGN_PATTERN, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(MOD_ID, "design_pattern_written")});
            ModelLoader.setCustomMeshDefinition((Item)Items.DESIGN_PATTERN, (ItemMeshDefinition)new ItemDesignPatternMeshDefinition());
        });
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        String matchName = "design_pattern_written";
        for (ModelResourceLocation modelResourceLocation : modelRegistry.func_148742_b()) {
            if (!modelResourceLocation.func_110624_b().equals(MOD_ID) || !modelResourceLocation.func_110623_a().equals(matchName)) continue;
            modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)new ItemDesignPatternBakedModel((IBakedModel)modelRegistry.func_82594_a((Object)modelResourceLocation)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientInitializationEvent(FMLInitializationEvent event) {
        super.onClientInitializationEvent(event);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186730_a((stack, tintIndex) -> {
            IArtisanRecipe recipe;
            String recipeName;
            if (stack.func_77973_b() instanceof IItemDesignPattern && (recipeName = ((IItemDesignPattern)stack.func_77973_b()).getRecipeName(stack)) != null && (recipe = ArtisanAPI.getRecipe(recipeName)) != null) {
                ItemStack output = recipe.getOutputWeightPairList().get(0).getOutput().toItemStack();
                return itemColors.func_186728_a(output, tintIndex);
            }
            return 0xFFFFFF;
        }, new Item[]{Items.DESIGN_PATTERN});
    }

    private void injectAPI() {
        Injector injector = new Injector();
        injector.inject(RecipeBuilder.class, "RECIPE_BUILDER_PROVIDER", RecipeBuilderInternal::get);
        injector.inject(RecipeBuilder.Copy.class, "RECIPE_BUILDER_COPY_STRATEGY_PROVIDER", (Object)new IRecipeBuilderCopyStrategyProvider(){

            @Override
            public IRecipeBuilderCopyStrategy byName(String recipeName) {
                return RecipeBuilder.Copy.byName(recipeName);
            }

            @Override
            public IRecipeBuilderCopyStrategy byRecipe(ICraftingRecipe recipe) {
                return RecipeBuilder.Copy.byRecipe(recipe);
            }

            @Override
            public IRecipeBuilderCopyStrategy byOutput(IArtisanIngredient[] outputs) {
                return RecipeBuilder.Copy.byOutput(outputs);
            }
        });
    }

    public static class Items {
        public static final ItemDesignPattern DESIGN_PATTERN = new ItemDesignPattern();
    }

    public static class Blocks {
        public static final Block TAB_ICON = new BlockTabIcon();
        public static final BlockWorktable WORKTABLE = new BlockWorktable();
        public static final BlockWorkstation WORKSTATION = new BlockWorkstation();
        public static final BlockWorkshop WORKSHOP = new BlockWorkshop();
    }

    public static class Textures {
        public static final String WORKTABLE_GUI = "textures/gui/worktable_%s.png";
        public static final String WORKSTATION_GUI = "textures/gui/workstation_%s.png";
        public static final String WORKSHOP_GUI = "textures/gui/workshop_%s.png";
    }

    public static class Lang {
        public static final String WORKTABLE_TITLE = "tile.artisanworktables.worktable.%s.name";
        public static final String WORKSTATION_TITLE = "tile.artisanworktables.workstation.%s.name";
        public static final String WORKSHOP_TITLE = "tile.artisanworktables.workshop.%s.name";
        public static final String JEI_TOOLTIP_SHAPELESS_RECIPE = "jei.artisanworktables.tooltip.shapeless.recipe";
        public static final String JEI_TOOLTIP_CHANCE = "jei.artisanworktables.tooltip.chance";
        public static final String JEI_XP_COST = "jei.artisanworktables.xp.cost";
        public static final String JEI_XP_REQUIRED = "jei.artisanworktables.xp.required";
        public static final String JEI_LEVEL_COST = "jei.artisanworktables.level.cost";
        public static final String JEI_LEVEL_REQUIRED = "jei.artisanworktables.level.required";
        public static final String GUI_TOOLTIP_FLUID_DESTROY = "gui.artisanworktables.tooltip.fluid.destroy";
        public static final String GUI_TOOLTIP_FLUID_EMPTY = "gui.artisanworktables.tooltip.fluid.empty";
        public static final String ITEM_TOOLTIP_CREATIVE_TABLE_OREDICT_NONE = "item.artisanworktables.tooltip.creative.table.oredict.none";
        public static final String ITEM_TOOLTIP_CREATIVE_TABLE_OREDICT_HEADER = "item.artisanworktables.tooltip.creative.table.oredict.header";
    }
}

