/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworktables.api;

import com.codetaylor.mc.artisanworktables.api.ArtisanRegistries;
import com.codetaylor.mc.artisanworktables.api.ArtisanToolHandlers;
import com.codetaylor.mc.artisanworktables.api.internal.recipe.RecipeRegistry;
import com.codetaylor.mc.artisanworktables.api.internal.reference.EnumType;
import com.codetaylor.mc.artisanworktables.api.recipe.IArtisanRecipe;
import com.codetaylor.mc.artisanworktables.api.recipe.IToolHandler;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirement;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementBuilder;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.IRequirementContext;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementBuilderSupplier;
import com.codetaylor.mc.artisanworktables.api.recipe.requirement.RequirementContextSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ArtisanAPI {
    public static final Supplier<String> MOD_ID = () -> "";
    private static final List<String> WORKTABLE_NAME_LIST;

    public static List<String> getWorktableNames() {
        return WORKTABLE_NAME_LIST;
    }

    public static boolean isWorktableNameValid(String name) {
        return WORKTABLE_NAME_LIST.contains(name.toLowerCase());
    }

    @Nullable
    public static IArtisanRecipe getRecipe(String recipeName) {
        String[] split = recipeName.split(":");
        RecipeRegistry registry = ArtisanAPI.getWorktableRecipeRegistry(split[0]);
        return registry.getRecipe(recipeName);
    }

    public static RecipeRegistry getWorktableRecipeRegistry(String tableName) {
        RecipeRegistry recipeRegistry = (RecipeRegistry)ArtisanRegistries.RECIPE_REGISTRY.getValue(new ResourceLocation(MOD_ID.get(), tableName));
        if (recipeRegistry == null) {
            throw new IllegalStateException("Can't find recipe registry for table: " + tableName);
        }
        return recipeRegistry;
    }

    public static boolean containsRecipeWithTool(ItemStack itemStack) {
        IToolHandler toolHandler = ArtisanToolHandlers.get(itemStack);
        for (RecipeRegistry registry : ArtisanRegistries.RECIPE_REGISTRY.getValuesCollection()) {
            if (!registry.containsRecipeWithTool(toolHandler, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static IRequirementContext getRequirementContext(ResourceLocation key) {
        RequirementContextSupplier supplier = (RequirementContextSupplier)ArtisanRegistries.REQUIREMENT_CONTEXT_SUPPLIER.getValue(key);
        if (supplier == null) {
            throw new IllegalStateException("No requirement context supplier registered for: " + key);
        }
        return supplier.get();
    }

    public static <C extends IRequirementContext, R extends IRequirement<C>> IRequirementBuilder<C, R> getRequirementBuilder(ResourceLocation key) {
        RequirementBuilderSupplier supplier = (RequirementBuilderSupplier)ArtisanRegistries.REQUIREMENT_BUILDER_SUPPLIER.getValue(key);
        if (supplier == null) {
            throw new IllegalStateException("No requirement builder supplier registered for: " + key);
        }
        return supplier.get();
    }

    private ArtisanAPI() {
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(EnumType.NAMES));
        WORKTABLE_NAME_LIST = Collections.unmodifiableList(new ArrayList(list));
    }
}

