/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.dataloader.sources;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import net.darkhax.bookshelf.dataloader.DataLoader;
import net.darkhax.bookshelf.dataloader.sources.DataProviderPredicate;
import net.minecraft.util.ResourceLocation;

public class DataProviderConfigs
extends DataProviderPredicate {
    private final File configDir;

    public DataProviderConfigs(String modid) {
        this(new File("config/" + modid + "/additions"));
    }

    public DataProviderConfigs(File configDir) {
        this.configDir = configDir;
        if (!this.configDir.exists()) {
            this.configDir.mkdirs();
        }
    }

    @Override
    public void provideDataToProcessors(DataLoader loader) {
        for (Map.Entry<String, BiConsumer<ResourceLocation, BufferedReader>> entry : loader.getProcessors().entrySet()) {
            File dirToLoad = new File(this.configDir, entry.getKey());
            if (!dirToLoad.isDirectory()) continue;
            for (File file : dirToLoad.listFiles()) {
                Path filePath = file.toPath();
                if (!this.getPathValidator().test(filePath)) continue;
                try (BufferedReader reader = Files.newBufferedReader(filePath);){
                    entry.getValue().accept(null, reader);
                }
                catch (Exception e) {
                    loader.getLogger().error("Failed to read file {}. The file was not valid.", (Object)file);
                    loader.getLogger().catching((Throwable)e);
                }
            }
        }
    }
}

