/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementSlider;
import cofh.core.gui.element.listbox.SliderHorizontal;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.gui.container.ContainerRelay;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiRelay
extends GuiContainerCore {
    static final String TEX_PATH = "thermaldynamics:textures/gui/relay.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/relay.png");
    private final Relay relay;
    public ElementButton buttonType;
    public ElementButton buttonColor;
    public ElementSlider slider;
    private ElementButton buttonInvert;
    ContainerRelay container;

    public GuiRelay(Relay relay) {
        super((Container)new ContainerRelay(relay), TEXTURE);
        this.relay = relay;
        this.drawInventory = false;
        this.name = "item.thermaldynamics.relay.name";
        this.container = (ContainerRelay)this.field_147002_h;
        this.field_147000_g = 74;
        this.field_146999_f = 202;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!"".equals(this.myInfo)) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        this.buttonType = new ElementButton((GuiContainerCore)this, 8, 16, "ButtonType", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonType);
        this.buttonInvert = new ElementButton((GuiContainerCore)this, 34, 16, "ButtonInvert", 0, 204, 0, 224, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonInvert);
        this.buttonColor = new ElementButton((GuiContainerCore)this, 60, 16, "ButtonColor", 0, 164, 0, 184, 20, 20, TEX_PATH);
        this.addElement((ElementBase)this.buttonColor);
        this.slider = new SliderHorizontal(this, 88, 16, 100, 20, 15){

            public void onValueChanged(int value) {
                GuiRelay.this.relay.setThreshold((byte)value);
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void onStopDragging() {
                GuiRelay.this.relay.sendUpdatePacket();
            }

            public void addTooltip(List<String> list) {
                list.add(StringHelper.localize((String)"info.thermaldynamics.relay.threshold") + " " + this._value);
            }
        }.setValue((int)this.relay.threshold);
        this.addElement((ElementBase)this.slider);
        this.update();
    }

    private void update() {
        this.slider.setEnabled(this.relay.shouldThreshold());
        this.slider.setVisible(this.relay.shouldThreshold());
        this.buttonType.setSheetX(20 * this.relay.type);
        this.buttonType.setHoverX(20 * this.relay.type);
        this.buttonType.setToolTip("info.thermaldynamics.relay.type." + this.relay.type);
        this.buttonInvert.setSheetX(60 + 20 * this.relay.invert);
        this.buttonInvert.setHoverX(60 + 20 * this.relay.invert);
        this.buttonInvert.setToolTip("info.thermaldynamics.relay.invert." + this.relay.invert);
        int colorX = this.relay.color % 8 * 20;
        int colorY = this.relay.color < 8 ? 124 : 164;
        this.buttonColor.setSheetX(colorX);
        this.buttonColor.setHoverX(colorX);
        this.buttonColor.setSheetY(colorY);
        this.buttonColor.setHoverY(colorY + 20);
        this.buttonColor.setToolTip("info.thermaldynamics.relay.color." + this.relay.color);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        int v;
        super.handleElementButtonClick(buttonName, mouseButton);
        int n = v = mouseButton == 0 ? 1 : -1;
        if ("ButtonInvert".equals(buttonName)) {
            this.relay.invert = (byte)((this.relay.invert + 4 + v) % 4);
            this.relay.sendUpdatePacket();
            GuiRelay.playClickSound((float)(v == 1 ? 0.6f : 0.5f));
        } else if ("ButtonType".equals(buttonName)) {
            this.relay.type = (byte)((this.relay.type + 3 + v) % 3);
            this.relay.sendUpdatePacket();
            GuiRelay.playClickSound((float)(v == 1 ? 0.6f : 0.5f));
        } else if ("ButtonColor".equals(buttonName)) {
            this.relay.color = (byte)((this.relay.color + 16 + v) % 16);
            this.relay.sendUpdatePacket();
            GuiRelay.playClickSound((float)(v == 1 ? 0.6f : 0.5f));
        }
        this.update();
    }

    protected void func_146979_b(int x, int y) {
        int gY;
        int rY;
        super.func_146979_b(x, y);
        if (this.relay.isInput()) {
            rY = 45;
            gY = 58;
        } else {
            gY = 45;
            rY = 58;
        }
        this.field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.relayRS") + ": " + this.container.relayPower, 8, rY, 0x404040);
        this.field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.relay.gridRS") + ": " + this.container.gridPower, 8, gY, 0x404040);
    }
}

