/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.GridTransport;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class DuctUnitTransportLongRange
extends DuctUnitTransportBase {
    public DuctUnitTransportLongRange(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    public GridTransport createGrid() {
        return null;
    }

    @Override
    public void formGrid() {
        this.onNeighborBlockChange();
        for (int i = 0; i < EnumFacing.field_82609_l.length; i = (int)((byte)(i + 1))) {
            if (!(((DuctUnitTransportBase[])this.ductCache)[i] instanceof DuctUnitTransportLongRange)) continue;
            ((DuctUnitTransportBase[])this.ductCache)[i].onNeighborBlockChange();
        }
    }

    @Override
    public boolean isValidForForming() {
        return false;
    }

    public byte nextDirection(byte k) {
        byte dir = -1;
        for (int i = 0; i < 6; ++i) {
            if (k == (i ^ 1) || ((DuctUnitTransportBase[])this.ductCache)[i] == null) continue;
            if (dir != -1) {
                return -1;
            }
            dir = (byte)i;
        }
        return dir;
    }

    @Override
    public void advanceEntity(EntityTransport t) {
        int v = t.progress;
        t.progress = (byte)((v += t.step * 2) % 100);
        if (v >= 100) {
            if (((DuctUnitTransportBase[])this.ductCache)[t.direction] != null) {
                DuctUnitTransportBase newHome = (DuctUnitTransportBase)this.getConnectedSide(t.direction);
                newHome.onNeighborBlockChange();
                if (((DuctUnitTransportBase[])newHome.ductCache)[t.direction ^ 1] != null) {
                    t.pos = newHome.pos();
                    t.oldDirection = t.direction;
                    if (newHome instanceof DuctUnitTransportLongRange) {
                        DuctUnitTransportLongRange lr = (DuctUnitTransportLongRange)newHome;
                        t.direction = lr.nextDirection(t.direction);
                        if (t.direction == -1) {
                            t.dropPassenger();
                        }
                    } else if (t.myPath != null) {
                        if (t.myPath.hasNextDirection()) {
                            t.direction = t.myPath.getNextDirection();
                        } else {
                            t.reRoute = true;
                        }
                    }
                }
            } else {
                t.dropPassenger();
            }
        } else if (t.progress >= 50 && t.progress - t.step < 50 && ((DuctUnitTransportBase[])this.ductCache)[t.direction] == null) {
            t.dropPassenger();
        }
    }

    @Override
    public boolean advanceEntityClient(EntityTransport t) {
        int v = t.progress;
        t.progress = (byte)((v += t.step + t.step) % 100);
        return v >= 100 && !t.trySimpleAdvance();
    }

    @Override
    public boolean isRoutable() {
        return false;
    }

    @Override
    public boolean isCrossover() {
        return false;
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitTransportBase, GridTransport, DuctUnitTransportBase.TransportDestination> adjDuct, byte side, byte oppositeSide) {
        return adjDuct.cast().isLongRange() || adjDuct.cast().isCrossover();
    }

    @Override
    @Nullable
    public DuctUnitTransportBase.TransportDestination cacheTile(@Nonnull TileEntity tile, byte side) {
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
    }

    @Override
    public boolean hasTooManyConnections() {
        int i = 0;
        for (DuctUnitTransportBase ductUnitTransportBase : (DuctUnitTransportBase[])this.ductCache) {
            if (ductUnitTransportBase == null || ++i <= 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Route getRoute(Entity entityTransport, int direction, byte step) {
        return null;
    }

    @Override
    @Nonnull
    protected BlockDuct.ConnectionType getConnectionTypeDuct(DuctUnitTransportBase duct, int side) {
        if (this.hasTooManyConnections() || duct.hasTooManyConnections()) {
            return BlockDuct.ConnectionType.NONE;
        }
        return super.getConnectionTypeDuct(duct, side);
    }
}

