/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.entities;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBuggy
extends Render<EntityBuggy> {
    private OBJModel.OBJBakedModel mainModel;
    private OBJModel.OBJBakedModel radarDish;
    private OBJModel.OBJBakedModel wheelLeftCover;
    private OBJModel.OBJBakedModel wheelRight;
    private OBJModel.OBJBakedModel wheelLeft;
    private OBJModel.OBJBakedModel wheelRightCover;
    private OBJModel.OBJBakedModel cargoLeft;
    private OBJModel.OBJBakedModel cargoMid;
    private OBJModel.OBJBakedModel cargoRight;

    private void updateModels() {
        if (this.mainModel == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galacticraftcore", "buggy.obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.mainModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"MainBody"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.radarDish = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"RadarDish_Dish"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.wheelLeftCover = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Left_Cover"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.wheelRight = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Right"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.wheelLeft = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Left"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.wheelRightCover = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Wheel_Right_Cover"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.cargoLeft = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoLeft"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.cargoMid = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoMid"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.cargoRight = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"CargoRight"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RenderBuggy(RenderManager manager) {
        super(manager);
        this.field_76989_e = 1.0f;
    }

    protected ResourceLocation getEntityTexture(EntityBuggy entity) {
        return TextureMap.field_110575_b;
    }

    public void doRender(EntityBuggy entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.41f, (float)0.41f, (float)0.41f);
        this.updateModels();
        this.func_180548_c(entity);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179094_E();
        float dZ = -2.727f;
        float dY = 0.976f;
        float dX = 1.25f;
        float rotation = entity.wheelRotationX;
        GlStateManager.func_179109_b((float)dX, (float)dY, (float)dZ);
        GlStateManager.func_179114_b((float)entity.wheelRotationZ, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelRightCover);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelRight);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-dX), (float)dY, (float)dZ);
        GlStateManager.func_179114_b((float)entity.wheelRotationZ, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelLeftCover);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelLeft);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        dX = 1.9f;
        dZ = -dZ;
        GlStateManager.func_179109_b((float)dX, (float)dY, (float)dZ);
        GlStateManager.func_179114_b((float)(-entity.wheelRotationZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelRight);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-dX), (float)dY, (float)dZ);
        GlStateManager.func_179114_b((float)(-entity.wheelRotationZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.wheelLeft);
        GlStateManager.func_179121_F();
        ClientUtil.drawBakedModel((IBakedModel)this.mainModel);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-1.178f, (float)4.1f, (float)-2.397f);
        int ticks = entity.field_70173_aa + entity.func_145782_y() * 10000;
        GlStateManager.func_179114_b((float)((float)Math.sin((double)ticks * 0.05) * 50.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.cos((double)ticks * 0.1) * 50.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.radarDish);
        GlStateManager.func_179121_F();
        if (entity.buggyType > 0) {
            ClientUtil.drawBakedModel((IBakedModel)this.cargoLeft);
            if (entity.buggyType > 1) {
                ClientUtil.drawBakedModel((IBakedModel)this.cargoMid);
                if (entity.buggyType > 2) {
                    ClientUtil.drawBakedModel((IBakedModel)this.cargoRight);
                }
            }
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public boolean shouldRender(EntityBuggy buggy, ICamera camera, double camX, double camY, double camZ) {
        AxisAlignedBB axisalignedbb = buggy.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0);
        return buggy.func_145770_h(camX, camY, camZ) && camera.func_78546_a(axisalignedbb);
    }
}

