/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModNecrotic
extends ModifierTrait {
    public ModNecrotic() {
        super("necrotic", 0x5E0000, 10, 0);
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        float amount;
        if (wasHit && (amount = damageDealt * this.lifesteal(TinkerUtil.getModifierTag(tool, this.getModifierIdentifier()))) > 0.0f) {
            player.func_70691_i(amount);
        }
    }

    private float lifesteal(NBTTagCompound modifierNBT) {
        ModifierNBT data = new ModifierNBT(modifierNBT);
        return 0.1f * (float)data.level;
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        float amount = this.lifesteal(modifierTag);
        return ImmutableList.of((Object)Util.translateFormatted(loc, Util.dfPercent.format(amount)));
    }
}

