/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModAntiMonsterType
extends ModifierTrait {
    protected final EnumCreatureAttribute type;
    private final float dmgPerItem;

    public ModAntiMonsterType(String identifier, int color, int maxLevel, int countPerLevel, EnumCreatureAttribute type) {
        super(identifier, color, maxLevel, countPerLevel);
        this.type = type;
        this.dmgPerItem = 7.0f / (float)countPerLevel;
    }

    protected float calcIncreasedDamage(NBTTagCompound modifierTag, float baseDamage) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        return baseDamage + (float)data.current * this.dmgPerItem;
    }

    @Override
    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        if (target.func_70668_bt() == this.type) {
            NBTTagCompound tag = TinkerUtil.getModifierTag(tool, this.identifier);
            return this.calcIncreasedDamage(tag, newDamage);
        }
        return super.damage(tool, player, target, damage, newDamage, isCritical);
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        if (I18n.func_94522_b((String)loc)) {
            float dmg = this.calcIncreasedDamage(modifierTag, 0.0f);
            return ImmutableList.of((Object)Util.translateFormatted(loc, Util.df.format(dmg)));
        }
        return super.getExtraInfo(tool, modifierTag);
    }
}

