/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.ICast;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

public class ItemBlockTable
extends ItemBlockMeta {
    public ItemBlockTable(Block block) {
        super(block);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!stack.func_77942_o()) {
            return;
        }
        ItemStack legs = ItemBlockTable.getLegStack(stack);
        if (!legs.func_190926_b()) {
            tooltip.add(legs.func_82833_r());
        }
        if (stack.func_77978_p().func_74764_b("inventory")) {
            this.addInventoryInformation(stack, worldIn, tooltip, flagIn);
        }
    }

    public static ItemStack getLegStack(ItemStack table) {
        NBTTagCompound tag = TagUtil.getTagSafe(table).func_74775_l("textureBlock");
        return new ItemStack(tag);
    }

    protected void addInventoryInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound inventory = stack.func_77978_p().func_74775_l("inventory");
        if (!inventory.func_74764_b("Items")) {
            return;
        }
        NBTTagList items = inventory.func_150295_c("Items", 10);
        if (items.func_82582_d()) {
            return;
        }
        if (BlockToolTable.TableTypes.fromMeta(stack.func_77952_i()) == BlockToolTable.TableTypes.PatternChest) {
            String desc = null;
            for (int i = 0; i < items.func_74745_c(); ++i) {
                Item item;
                ItemStack inventoryStack = new ItemStack(items.func_150305_b(i));
                if (inventoryStack.func_190926_b() || !((item = inventoryStack.func_77973_b()) instanceof ICast) && !(item instanceof IPattern)) continue;
                desc = item instanceof ICast ? "tooltip.patternchest.holds_casts" : "tooltip.patternchest.holds_patterns";
                break;
            }
            if (desc != null) {
                tooltip.addAll(LocUtils.getTooltips((String)Util.translateFormatted(desc, items.func_74745_c())));
            }
        } else {
            tooltip.addAll(LocUtils.getTooltips((String)Util.translateFormatted("tooltip.chest.has_items", items.func_74745_c())));
        }
    }
}

