/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import slimeknights.tconstruct.shared.block.BlockTable;

public class TableRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = recipe.getWidth();
        primer.height = recipe.getHeight();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = recipe.func_192400_c();
        JsonElement elem = TableRecipeFactory.getElement(json, "variants");
        return new TableRecipe(recipe.func_193358_e().isEmpty() ? null : new ResourceLocation(recipe.func_193358_e()), CraftingHelper.getIngredient((JsonElement)elem, (JsonContext)context), recipe.func_77571_b(), primer);
    }

    public static JsonElement getElement(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return json.get(memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + " from the current json, Invalid JSON!");
    }

    public static class TableRecipe
    extends ShapedOreRecipe {
        public final Ingredient ingredients;

        public TableRecipe(ResourceLocation group, Ingredient ingredientIn, ItemStack result, CraftingHelper.ShapedPrimer primer) {
            super(group, result, primer);
            this.ingredients = ingredientIn;
        }

        @Nonnull
        public ItemStack func_77572_b(InventoryCrafting craftMatrix) {
            for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                for (ItemStack ore : this.ingredients.func_193365_a()) {
                    ItemStack stack = craftMatrix.func_70301_a(i);
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false) || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                    BlockTable block = (BlockTable)Block.func_149634_a((Item)this.output.func_77973_b());
                    return BlockTable.createItemstack(block, this.output.func_77952_i(), Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
                }
            }
            return super.func_77572_b(craftMatrix);
        }

        @Nonnull
        public ItemStack func_77571_b() {
            if (this.ingredients.func_193365_a().length != 0 && !this.output.func_190926_b()) {
                ItemStack stack = this.ingredients.func_193365_a()[0];
                BlockTable block = (BlockTable)Block.func_149634_a((Item)this.output.func_77973_b());
                int meta = stack.func_77952_i();
                if (meta == Short.MAX_VALUE) {
                    meta = 0;
                }
                return BlockTable.createItemstack(block, this.output.func_77952_i(), Block.func_149634_a((Item)stack.func_77973_b()), meta);
            }
            return super.func_77571_b();
        }

        public ItemStack getPlainRecipeOutput() {
            return this.output;
        }
    }
}

