/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.MaterialItem;

public class MaterialMatch
extends RecipeMatch {
    private final Material material;

    public MaterialMatch(Material material, int amountNeeded, int amountMatched) {
        super(amountMatched, amountMatched);
        this.material = material;
    }

    public MaterialMatch(Material material, int amountNeeded) {
        this(material, amountNeeded, 2);
    }

    public MaterialMatch(Material material) {
        this(material, 1, 2);
    }

    public List<ItemStack> getInputs() {
        return ImmutableList.of();
    }

    public Optional<RecipeMatch.Match> matches(NonNullList<ItemStack> stacks) {
        LinkedList found = Lists.newLinkedList();
        int stillNeeded = this.amountNeeded;
        for (ItemStack stack : stacks) {
            if (!(stack.func_77973_b() instanceof MaterialItem) || this.material != ((MaterialItem)stack.func_77973_b()).getMaterial(stack)) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.min(copy.func_190916_E(), stillNeeded));
            found.add(copy);
            if ((stillNeeded -= copy.func_190916_E()) > 0) continue;
            return Optional.of(new RecipeMatch.Match((List)found, this.amountMatched));
        }
        return Optional.empty();
    }
}

