/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.events;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.entity.EntityProjectileBase;
import slimeknights.tconstruct.library.events.TinkerEvent;

public class ProjectileEvent
extends TinkerEvent {
    public final Entity projectileEntity;
    @Nullable
    public final EntityProjectileBase projectile;

    public ProjectileEvent(Entity projectile) {
        this.projectileEntity = projectile;
        this.projectile = projectile instanceof EntityProjectileBase ? (EntityProjectileBase)projectile : null;
    }

    public static class OnHitBlock
    extends ProjectileEvent {
        public final float speed;
        public final BlockPos pos;
        public final IBlockState blockState;

        public OnHitBlock(EntityProjectileBase projectile, float speed, BlockPos pos, IBlockState blockState) {
            super((Entity)projectile);
            this.speed = speed;
            this.pos = pos;
            this.blockState = blockState;
        }

        public static void fireEvent(EntityProjectileBase projectile, float speed, BlockPos pos, IBlockState blockState) {
            MinecraftForge.EVENT_BUS.post((Event)new OnHitBlock(projectile, speed, pos, blockState));
        }
    }

    @Cancelable
    public static class OnLaunch
    extends ProjectileEvent {
        @Nullable
        public final ItemStack launcher;
        @Nullable
        public final EntityLivingBase shooter;

        public OnLaunch(Entity projectile, ItemStack launcher, EntityLivingBase shooter) {
            super(projectile);
            this.launcher = launcher;
            this.shooter = shooter;
        }

        public static boolean fireEvent(Entity projectile, ItemStack launcher, EntityLivingBase shooter) {
            return !MinecraftForge.EVENT_BUS.post((Event)new OnLaunch(projectile, launcher, shooter));
        }
    }
}

