/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class MetalColoredTexture
extends AbstractColoredTexture {
    protected int baseColor;
    protected float shinyness;
    protected float brightness;
    protected float hueshift;

    public MetalColoredTexture(ResourceLocation baseTexture, String spriteName, int baseColor, float shinyness, float brightness, float hueshift) {
        super(baseTexture, spriteName);
        this.baseColor = baseColor;
        this.shinyness = shinyness;
        this.brightness = brightness;
        this.hueshift = hueshift;
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        float l = (float)MetalColoredTexture.getPerceptualBrightness(pixel) / 255.0f;
        int c = this.baseColor;
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        r = MetalColoredTexture.mult(r, RenderUtil.red(pixel)) & 0xFF;
        g = MetalColoredTexture.mult(g, RenderUtil.blue(pixel)) & 0xFF;
        b = MetalColoredTexture.mult(b, RenderUtil.green(pixel)) & 0xFF;
        float[] hsl = Color.RGBtoHSB(r, g, b, null);
        hsl[0] = hsl[0] - (0.5f - l * l) * this.hueshift;
        if (l > 0.9f) {
            hsl[1] = MathHelper.func_76131_a((float)(hsl[1] - l * l * this.shinyness), (float)0.0f, (float)1.0f);
        }
        if (l > 0.8f) {
            hsl[2] = MathHelper.func_76131_a((float)(hsl[2] + l * l * this.brightness), (float)0.0f, (float)1.0f);
        }
        c = Color.HSBtoRGB(hsl[0], hsl[1], hsl[2]);
        r = RenderUtil.red(c);
        b = RenderUtil.blue(c);
        g = RenderUtil.green(c);
        return RenderUtil.compose(r, g, b, a);
    }
}

