/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.tinkering.IModifyable;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.IToolStationDisplay;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;

public class ItemMomsSpaghetti
extends ItemFood
implements IRepairable,
IModifyable,
IToolStationDisplay {
    public static final String LOC_NAME = "item.tconstruct.moms_spaghetti.name";
    public static final String LOC_DESC = "item.tconstruct.moms_spaghetti.desc";
    public static final String LOC_USES = "stat.spaghetti.uses.name";
    public static final String LOC_NOURISHMENT = "stat.spaghetti.nourishment.name";
    public static final String LOC_SATURATION = "stat.spaghetti.saturation.name";
    public static final String LOC_TOOLTIP = "item.tconstruct.moms_spaghetti.tooltip";
    public static final int MAX_USES = 100;
    public static final int USES_PER_WHEAT = 1;

    public ItemMomsSpaghetti() {
        super(2, 0.2f, false);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(null);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public float func_150906_h(ItemStack stack) {
        float saturation = super.func_150906_h(stack);
        if (ItemMomsSpaghetti.hasSauce(stack)) {
            saturation += 0.2f;
        }
        return saturation;
    }

    public int func_150905_g(ItemStack stack) {
        int heal = super.func_150905_g(stack);
        if (ItemMomsSpaghetti.hasMeat(stack)) {
            ++heal;
        }
        return heal;
    }

    protected static boolean hasModifier(ItemStack stack, String identifier) {
        return TinkerUtil.hasModifier(TagUtil.getTagSafe(stack), identifier);
    }

    public static boolean hasSauce(ItemStack stack) {
        return ItemMomsSpaghetti.hasModifier(stack, TinkerGadgets.modSpaghettiSauce.getIdentifier());
    }

    public static boolean hasMeat(ItemStack stack) {
        return ItemMomsSpaghetti.hasModifier(stack, TinkerGadgets.modSpaghettiMeat.getIdentifier());
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        stack.func_77964_b(stack.func_77952_i() + 1);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_151686_a((ItemFood)this, stack);
            worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            StatBase statBase = StatList.func_188057_b((Item)this);
            assert (statBase != null);
            entityplayer.func_71029_a(statBase);
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 10;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (playerIn.func_71043_e(false) && this.getUses(itemStackIn) > 0) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
    }

    public int getUses(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @Override
    public ItemStack repair(ItemStack repairable, NonNullList<ItemStack> repairItems) {
        if (repairable.func_77952_i() == 0) {
            return ItemStack.field_190927_a;
        }
        boolean allEmpty = true;
        for (ItemStack repairItem : repairItems) {
            if (repairItem.func_190926_b()) continue;
            allEmpty = false;
            if (repairItem.func_77973_b() == Items.field_151015_O) continue;
            return ItemStack.field_190927_a;
        }
        if (allEmpty) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = repairable.func_77946_l();
        int index = 0;
        while (stack.func_77952_i() > 0 && index < repairItems.size()) {
            ItemStack repairItem = (ItemStack)repairItems.get(index);
            if (!repairItem.func_190926_b() && repairItem.func_190916_E() > 0) {
                repairItem.func_190918_g(1);
                ToolHelper.healTool(stack, 1, null);
                continue;
            }
            ++index;
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(String.format("%s: %s", Util.translate(LOC_USES, new Object[0]), CustomFontColor.formatPartialAmount(this.getUses(stack), this.getMaxDamage(stack))));
        TooltipBuilder.addModifierTooltips(stack, tooltip);
        tooltip.add("");
        int i = 1;
        if (ItemMomsSpaghetti.hasMeat(stack)) {
            i = 3;
        } else if (ItemMomsSpaghetti.hasSauce(stack)) {
            i = 2;
        }
        tooltip.addAll(LocUtils.getTooltips((String)Util.translate(LOC_TOOLTIP + i, new Object[0])));
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return ClientProxy.fontRenderer;
    }

    @Override
    public String getLocalizedToolName() {
        return Util.translate(LOC_NAME, new Object[0]);
    }

    @Override
    public List<String> getInformation(ItemStack stack) {
        int nourishment = this.func_150905_g(stack);
        float saturation = this.func_150906_h(stack);
        return ImmutableList.of((Object)Util.translate(LOC_DESC, new Object[0]), (Object)(String.format("%s: %s", Util.translate(LOC_USES, new Object[0]), this.getUses(stack)) + TextFormatting.RESET), (Object)(String.format("%s: %s", Util.translate(LOC_NOURISHMENT, new Object[0]), nourishment) + TextFormatting.RESET), (Object)(String.format("%s: %s", Util.translate(LOC_SATURATION, new Object[0]), Util.dfPercent.format(saturation)) + TextFormatting.RESET));
    }
}

