/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class TextureDump {
    private static Field fName;
    private static Field fMip;

    @SubscribeEvent
    public void postTextureStitch(TextureStitchEvent.Post e) throws Exception {
        TextureDump.saveGlTexture(TextureDump.getName(e.getMap()), e.getMap().func_110552_b(), TextureDump.getMip(e.getMap()));
    }

    private static String getName(TextureMap map) throws Exception {
        if (fName == null) {
            fName = TextureMap.class.getDeclaredFields()[6];
            fName.setAccessible(true);
        }
        return ((String)fName.get(map)).replace('/', '_');
    }

    private static int getMip(TextureMap map) throws Exception {
        if (fMip == null) {
            fMip = TextureMap.class.getDeclaredFields()[8];
            fMip.setAccessible(true);
        }
        return fMip.getInt(map);
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels) {
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        for (int level = 0; level <= mipmapLevels; ++level) {
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097);
            int size = width * height;
            BufferedImage bufferedimage = new BufferedImage(width, height, 2);
            File output = new File(name + "_" + level + ".png");
            IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
            int[] data = new int[size];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buffer);
            buffer.get(data);
            bufferedimage.setRGB(0, 0, width, height, data, 0, width);
            try {
                ImageIO.write((RenderedImage)bufferedimage, "png", output);
                FMLLog.info((String)("[TextureDump] Exported png to: " + output.getAbsolutePath()), (Object[])new Object[0]);
                continue;
            }
            catch (IOException ioexception) {
                FMLLog.info((String)"[TextureDump] Unable to write: ", (Object[])new Object[]{ioexception});
            }
        }
    }
}

