/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class IMCIntegration {
    static final Logger log = Util.getLogger("IMC");
    private static List<FMLInterModComms.IMCMessage> earlyMessages = new LinkedList<FMLInterModComms.IMCMessage>();

    private IMCIntegration() {
    }

    public static void integrateSmeltery() {
        for (FMLInterModComms.IMCMessage message : FMLInterModComms.fetchRuntimeMessages((Object)TConstruct.instance)) {
            if (message.key.equals("integrateSmeltery")) {
                try {
                    IMCIntegration.integrateSmeltery(message);
                }
                catch (ClassCastException e) {
                    log.error("Got invalid integrateSmeltery IMC from {}", (Object)message.getSender());
                }
                continue;
            }
            earlyMessages.add(message);
        }
    }

    public static void handleIMC(FMLInterModComms.IMCEvent event) {
        IMCIntegration.handleMessages(earlyMessages);
        earlyMessages.clear();
        IMCIntegration.handleMessages((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    private static void handleMessages(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            try {
                switch (message.key) {
                    case "integrateSmeltery": {
                        log.error("Received integrateSmetery IMC from {} too late, must be sent during Register<Item> at latest!", (Object)message.getSender());
                        break;
                    }
                    case "alloy": {
                        IMCIntegration.alloy(message);
                        break;
                    }
                    case "blacklistMelting": {
                        IMCIntegration.blacklistMelting(message);
                        break;
                    }
                    case "addDryingRecipe": {
                        IMCIntegration.addDryingRecipe(message);
                        break;
                    }
                    case "addHeadDrop": {
                        IMCIntegration.addHeadDrop(message);
                        break;
                    }
                    default: {
                        log.error("Got invalid IMC type {} from {}", (Object)message.key, (Object)message.getSender());
                        break;
                    }
                }
            }
            catch (ClassCastException e) {
                log.error("Got invalid {} IMC from {}", (Object)message.key, (Object)message.getSender());
            }
        }
    }

    protected static void integrateSmeltery(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            log.error("Got invalid integrateSmeltery IMC from {}, expected NBT message", (Object)message.getSender());
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        String fluidName = tag.func_74779_i("fluid");
        String ore = tag.func_74779_i("ore");
        boolean toolforge = tag.func_74767_n("toolforge");
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null && !ore.isEmpty()) {
            boolean isNew = true;
            for (MaterialIntegration mi : TinkerRegistry.getMaterialIntegrations()) {
                if (mi.fluid == null || !mi.fluid.getName().equals(fluidName)) continue;
                isNew = false;
            }
            if (isNew) {
                MaterialIntegration materialIntegration = new MaterialIntegration(null, fluid, ore);
                if (toolforge) {
                    materialIntegration.toolforge();
                }
                TinkerRegistry.integrate(materialIntegration);
                materialIntegration.preInit();
                log.debug("Added integration smelting for " + ore + " from " + message.getSender());
            }
        }
        IMCIntegration.alloy(message);
    }

    protected static void alloy(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            log.error("Got invalid alloy IMC from {}, expected NBT message", (Object)message.getSender());
            return;
        }
        NBTTagCompound tags = message.getNBTValue();
        if (tags.func_150297_b("alloy", 9)) {
            NBTTagList list = tags.func_150295_c("alloy", 10);
            LinkedList fluids = Lists.newLinkedList();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (fs == null) {
                    log.error("Invalid alloy fluid in {} IMC", (Object)message.key);
                    return;
                }
                fluids.add(fs);
            }
            if (fluids.size() > 2) {
                FluidStack output = (FluidStack)fluids.get(0);
                FluidStack[] input = new FluidStack[fluids.size() - 1];
                input = fluids.subList(1, fluids.size()).toArray(input);
                TinkerRegistry.registerAlloy(output, input);
                log.debug("Added integration alloy: " + output.getLocalizedName());
            } else {
                log.error("Not enough alloy fluids in {} IMC, expected at least 3, got {}", (Object)message.key, (Object)fluids.size());
            }
        } else if (message.key.equals("alloy")) {
            log.error("Missing alloys for alloy IMC message from {}", (Object)message.getSender());
        }
    }

    protected static void blacklistMelting(FMLInterModComms.IMCMessage message) {
        if (message.isStringMessage()) {
            TinkerSmeltery.meltingBlacklist.addAll((Collection<ItemStack>)OreDictionary.getOres((String)message.getStringValue(), (boolean)false));
            log.debug("Blacklisted oredictionary entry " + message.getStringValue() + " from melting");
        } else if (message.isItemStackMessage()) {
            TinkerSmeltery.meltingBlacklist.add(message.getItemStackValue());
            log.debug("Blacklisted " + message.getItemStackValue().func_77977_a() + " from melting");
        } else {
            log.error("Got invalid blacklistMelting IMC from {}, expected string or ItemStack message", (Object)message.getSender());
        }
    }

    protected static void addDryingRecipe(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            log.error("Got invalid addDryingRecipe IMC from {}, expected NBT message", (Object)message.getSender());
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        ItemStack output = new ItemStack(tag.func_74775_l("output"));
        int time = tag.func_74762_e("time") * 20;
        if (!output.func_190926_b() && time > 0) {
            if (tag.func_150297_b("input", 10)) {
                ItemStack input = new ItemStack(tag.func_74775_l("input"));
                if (!input.func_190926_b()) {
                    TinkerRegistry.registerDryingRecipe(input, output, time);
                    log.debug("Added drying rack recipe from " + input.func_77977_a() + " to " + output.func_77977_a());
                }
            } else {
                String ore = tag.func_74779_i("input");
                if (!ore.isEmpty()) {
                    TinkerRegistry.registerDryingRecipe(ore, output, time);
                    log.debug("Added drying rack recipe from oredictionary " + ore + " to " + output.func_77977_a());
                } else {
                    log.error("Got invalid addDryingRecipe IMC from {}, missing input, must be a string or ItemStack", (Object)message.getSender());
                }
            }
        } else {
            log.error("Got invalid addDryingRecipe IMC from {},output must not be empty and time greater than 0", (Object)message.getSender());
        }
    }

    protected static void addHeadDrop(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        Class clazz = EntityList.func_192839_a((String)tag.func_74779_i("entity"));
        ItemStack head = new ItemStack(tag.func_74775_l("head"));
        if (clazz != null && EntityLivingBase.class.isAssignableFrom(clazz) && !head.func_190926_b()) {
            TinkerRegistry.registerHeadDrop((Class<? extends EntityLivingBase>)clazz, e -> head);
        } else {
            log.error("Got invalid addHeadDrop IMC from {}, head must not be empty and entity must be EntityLivingBase", (Object)message.getSender());
        }
    }
}

