/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.inoculator;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;
import binnie.core.machines.network.INetwork;
import binnie.core.util.EntityItemRenderer;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InoculatorFX
extends MachineComponent
implements IRender.DisplayTick,
IRender.Render,
INetwork.TilePacketSync {
    private final EntityItemRenderer entityItemRenderer = new EntityItemRenderer();

    public InoculatorFX(IMachine machine) {
        super(machine);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDisplayTick(World world, BlockPos pos, Random rand) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        int tick = (int)(world.func_82737_E() % 3L);
        if (tick == 0) {
            InoculatorParticle particle = new InoculatorParticle(world, pos);
            BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld(double x, double y, double z) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        ItemStack stack = this.getUtil().getStack(9);
        World world = this.getMachine().getWorld();
        this.entityItemRenderer.renderInWorld(stack, world, x + 0.5, y + 0.8, z + 0.5);
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        NBTTagCompound item = new NBTTagCompound();
        ItemStack stack = this.getUtil().getStack(9);
        if (!stack.func_190926_b()) {
            stack.func_77955_b(item);
            nbt.func_74782_a("item", (NBTBase)item);
        }
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("item")) {
            this.getUtil().setStack(9, new ItemStack(nbt.func_74775_l("item")));
        } else {
            this.getUtil().setStack(9, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onInventoryUpdate() {
        if (!this.getUtil().isServer()) {
            return;
        }
        this.getUtil().refreshBlock();
    }

    @SideOnly(value=Side.CLIENT)
    private static class InoculatorParticle
    extends Particle {
        private double axisX;
        private double axisZ;
        private double angle;

        public InoculatorParticle(World world, BlockPos pos) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.92, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.axisX = this.field_187126_f;
            this.axisZ = this.field_187128_h;
            this.angle = (double)((int)(this.field_187122_b.func_82737_E() % 4L)) * 0.5 * Math.PI;
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.007 + this.field_187136_p.nextDouble() * 0.002;
            this.field_70547_e = 240;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.func_70538_b(0.8f, 0.0f, 1.0f);
        }

        public void func_189213_a() {
            super.func_189213_a();
            double speed = 5.0E-4;
            if (this.field_70546_d > 60) {
                speed += (double)((float)(this.field_70546_d - 60) / 4000.0f);
            }
            this.angle += speed;
            double dist = 0.27;
            this.func_187109_b(this.axisX + 0.27 * Math.sin(this.angle), this.field_187127_g, this.axisZ + 0.27 * Math.cos(this.angle));
            this.func_82338_g((float)Math.cos(1.5707963267948966 * (double)this.field_70546_d / (double)this.field_70547_e));
            if (this.field_70546_d > 40) {
                this.func_70538_b(this.field_70552_h + (1.0f - this.field_70552_h) / 10.0f, this.field_70553_i + (0.0f - this.field_70553_i) / 10.0f, this.field_70551_j + (0.0f - this.field_70551_j) / 10.0f);
            }
        }

        public int func_70537_b() {
            return 0;
        }
    }
}

