/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.machines.MachineUtil;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.machines.transfer.TransferResult;
import binnie.genetics.machine.incubator.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IncubatorRecipe
implements IIncubatorRecipe {
    private final FluidStack input;
    @Nullable
    private final FluidStack output;
    private final ItemStack itemStack;
    private final float lossChance;
    private final float tickChance;
    private ItemStack outputStack;

    public IncubatorRecipe(ItemStack itemStack, FluidStack input, @Nullable FluidStack output, float lossChance) {
        this(itemStack, input, output, lossChance, 1.0f);
    }

    public IncubatorRecipe(ItemStack itemStack, FluidStack input, @Nullable FluidStack output, float lossChance, float chance) {
        this.itemStack = itemStack;
        this.outputStack = ItemStack.field_190927_a;
        this.input = input;
        this.output = output;
        this.lossChance = lossChance;
        this.tickChance = chance;
    }

    @Override
    public float getChance() {
        return this.tickChance;
    }

    @Override
    public float getLossChance() {
        return this.lossChance;
    }

    @Override
    public boolean isInputLiquid(@Nullable FluidStack fluid) {
        return fluid != null && this.input.isFluidEqual(fluid);
    }

    @Override
    public boolean isInputLiquidSufficient(@Nullable FluidStack fluid) {
        return fluid != null && fluid.amount >= this.input.amount;
    }

    @Override
    public FluidStack getInput() {
        return this.input;
    }

    @Override
    @Nullable
    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public ItemStack getInputStack() {
        return this.itemStack;
    }

    @Override
    public ItemStack getExpectedOutput() {
        return this.outputStack;
    }

    @Override
    public void doTask(MachineUtil machine) {
        Random rand;
        machine.drainTank(0, this.input.amount);
        if (this.output != null) {
            machine.fillTank(1, this.output);
        }
        this.outputStack = this.getOutputStack(machine);
        if (!this.outputStack.func_190926_b()) {
            ItemStack output = this.outputStack.func_77946_l();
            TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
            product.transfer(null, true);
        }
        if ((rand = machine.getRandom()).nextFloat() < this.lossChance) {
            machine.decreaseStack(3, 1);
        }
    }

    public IncubatorRecipe setOutputStack(ItemStack stack) {
        this.outputStack = stack;
        return this;
    }

    protected ItemStack getOutputStack(MachineUtil util) {
        return this.getExpectedOutput();
    }

    @Override
    public boolean roomForOutput(MachineUtil machine) {
        ItemStack outputStack;
        if (this.output != null && !machine.isTankEmpty(1)) {
            if (!this.output.isFluidEqual(machine.getFluid(1))) {
                return false;
            }
            if (!machine.spaceInTank(1, this.output.amount)) {
                return false;
            }
        }
        if (!(outputStack = this.getOutputStack(machine)).func_190926_b()) {
            ItemStack output = outputStack.func_77946_l();
            TransferRequest product = new TransferRequest(output, machine.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
            TransferResult transferResult = product.transfer(null, false);
            return transferResult.isSuccess() && (transferResult.getRemaining().isEmpty() || ((ItemStack)transferResult.getRemaining().get(0)).func_77973_b() == Items.field_190931_a);
        }
        return true;
    }
}

