/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.genetics.ManagerGenetics;
import binnie.core.gui.Widget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlide;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.window.Panel;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.util.I18N;
import binnie.core.util.Log;
import binnie.genetics.Genetics;
import binnie.genetics.api.analyst.IAnalystPagePlugin;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.gui.analyst.AnalystPageDatabase;
import binnie.genetics.gui.analyst.AnalystPageDescription;
import binnie.genetics.gui.analyst.AnalystPageGenome;
import binnie.genetics.gui.analyst.AnalystPageKaryogram;
import binnie.genetics.gui.analyst.AnalystPageMutations;
import binnie.genetics.gui.analyst.AnalystPanel;
import binnie.genetics.gui.analyst.ControlAnalystButton;
import binnie.genetics.gui.analyst.ControlSystemButton;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.modules.ModuleMachine;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowAnalyst
extends Window {
    @Nullable
    private IWidget baseWidget;
    private ControlScrollableContent leftPage;
    private ControlScrollableContent rightPage;
    @Nullable
    private Control tabBar;
    private Panel analystPanel;
    private final List<ITitledWidget> analystPages = new ArrayList<ITitledWidget>();
    @Nullable
    private IArea analystPageSize;
    private final boolean isDatabase;
    private final boolean isMaster;
    private final boolean lockedSearch;
    @Nullable
    private IIndividual current;
    @Nullable
    private IBreedingSystem currentSystem;
    private Control analystNone;
    private ControlSlide slideUpInv;

    public WindowAnalyst(EntityPlayer player, @Nullable IInventory inventory, Side side, boolean database, boolean master) {
        super(312, 230, player, inventory, side);
        this.isDatabase = database;
        this.isMaster = master;
        this.lockedSearch = this.isDatabase;
    }

    public static GeneticsGUI.WindowFactory create(boolean database, boolean master) {
        return (player, inventory, side) -> new WindowAnalyst(player, inventory, side, database, master);
    }

    @Override
    protected String getModId() {
        return Genetics.instance.getModId();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Analyst";
    }

    private void setupValidators() {
        if (!this.isDatabase) {
            this.getWindowInventory().setValidator(0, new AnalystSlotValidator(this));
            this.getWindowInventory().setValidator(1, new SlotValidator.Item(GeneticsItems.DNADye.get(1), ModuleMachine.getSpriteDye()));
        }
    }

    @Override
    public void initialiseServer() {
        for (IBreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            IBreedingTracker tracker;
            ISpeciesRoot root = system.getSpeciesRoot();
            if (root == null || (tracker = root.getBreedingTracker(this.getWorld(), this.getUsername())) == null) continue;
            tracker.synchToPlayer(this.getPlayer());
        }
        this.getWindowInventory().createSlot(0);
        this.getWindowInventory().createSlot(1);
        this.setupValidators();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(this.isDatabase ? (this.isMaster ? I18N.localise("genetics.gui.registry.master.title") : I18N.localise("genetics.gui.registry.title")) : I18N.localise("genetics.gui.analyst.title"));
        this.getWindowInventory().createSlot(0);
        this.baseWidget = new Widget(this);
        int x = 16;
        int y = 28;
        Collection<IBreedingSystem> activeSystems = Binnie.GENETICS.getActiveSystems();
        if (this.isDatabase) {
            for (IBreedingSystem syst : activeSystems) {
                new ControlSystemButton(x, y, this, syst);
                x += 22;
            }
        } else {
            new ControlSlot.Builder(this, x, y + 1).assign(InventoryType.WINDOW, 0);
            new ControlSlot.Builder(this, x += 22, y + 1).assign(InventoryType.WINDOW, 1);
            x += 26;
            this.setupValidators();
        }
        this.tabBar = new Control(this, x, 28, this.getWidth() - 16 - x, 20);
        this.analystPanel = new AnalystPanel(this);
        if (!this.isDatabase) {
            this.slideUpInv = new ControlSlide(this, (this.getSize().xPos() - 244) / 2, this.getSize().yPos() - 80 + 1, 244, 80, Alignment.BOTTOM);
            new ControlPlayerInventory((IWidget)this.slideUpInv, true);
            this.slideUpInv.setSlide(false);
        }
        this.addEventHandler(EventKey.Down.class, event -> {
            if (event.getKey() == 205) {
                this.shiftPages(true);
            }
            if (event.getKey() == 203) {
                this.shiftPages(false);
            }
        });
        if (!this.isDatabase) {
            this.analystNone = new AnalystNoneControl(this);
        }
        this.setIndividual(null);
        IBreedingSystem first = Binnie.GENETICS.getFirstActiveSystem();
        this.setSystem(first);
    }

    @SideOnly(value=Side.CLIENT)
    public void updatePages(boolean systemChange) {
        int oldLeft = -1;
        int oldRight = -1;
        if (!systemChange) {
            oldLeft = this.analystPages.indexOf(this.leftPage.getContent());
            oldRight = this.analystPages.indexOf(this.rightPage.getContent());
        }
        ITitledWidget databasePage = null;
        if (this.isDatabase && !systemChange) {
            databasePage = this.analystPages.size() > 0 ? this.analystPages.get(0) : null;
        }
        this.analystPages.clear();
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        this.createPages(databasePage);
        this.tabBar.deleteAllChildren();
        if (this.analystPages.size() > 0) {
            int width = this.tabBar.getWidth() / this.analystPages.size();
            int x = 0;
            for (ITitledWidget page : this.analystPages) {
                new ControlAnalystButton(this.tabBar, x, 0, width, this.tabBar.getHeight(), this, page);
                x += width;
            }
            this.setPage(this.leftPage, this.analystPages.get(Math.max(oldLeft, 0)));
            if (this.analystPages.size() > 1) {
                this.setPage(this.rightPage, this.analystPages.get(oldRight >= 0 ? oldRight : 1));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createPages(@Nullable ITitledWidget databasePage) {
        if (this.isDatabase) {
            this.analystPages.add(databasePage != null ? databasePage : new AnalystPageDatabase(this.analystPanel, this.analystPageSize, this.currentSystem, this.isMaster));
        }
        if (this.current != null) {
            this.analystPages.add(new AnalystPageDescription(this.analystPanel, this.analystPageSize, this.current));
            this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, true, this.current));
            if (!this.isDatabase) {
                this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, false, this.current));
                this.analystPages.add(new AnalystPageKaryogram(this.analystPanel, this.analystPageSize, this.current));
            }
            WindowAnalyst.createPages(this.current, this.analystPanel, this.analystPageSize, this.analystPages);
            this.analystPages.add(new AnalystPageMutations(this.analystPanel, this.analystPageSize, this.current, this.isMaster));
        }
        for (ITitledWidget page : this.analystPages) {
            page.hide();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static <T extends IIndividual> void createPages(T individual, IWidget parent, IArea pageSize, List<ITitledWidget> analystPages) {
        IAnalystPagePlugin<T> analystPageFactory = Genetics.getAnalystManager().getAnalystPagePlugin(individual);
        if (analystPageFactory != null) {
            analystPageFactory.addAnalystPages(individual, parent, pageSize, analystPages, Genetics.getAnalystManager());
        } else {
            Log.error("Could not find IAnalystPagePlugin for {}", individual.getClass());
        }
    }

    public void shiftPages(boolean right) {
        if (this.analystPages.size() < 2) {
            return;
        }
        int leftIndex = this.analystPages.indexOf(this.leftPage.getContent());
        int rightIndex = this.analystPages.indexOf(this.rightPage.getContent());
        if (right && rightIndex + 1 >= this.analystPages.size()) {
            return;
        }
        if (!this.lockedSearch && !right && leftIndex <= 0) {
            return;
        }
        if (!this.lockedSearch && !right && rightIndex <= 1) {
            return;
        }
        int newRightIndex = rightIndex + (right ? 1 : -1);
        int newLeftIndex = this.lockedSearch ? 0 : newRightIndex - 1;
        float oldRightPercent = 0.0f;
        float oldLeftPercent = 0.0f;
        if (newLeftIndex == rightIndex) {
            oldRightPercent = this.rightPage.getPercentageIndex();
        }
        if (newRightIndex == leftIndex) {
            oldLeftPercent = this.leftPage.getPercentageIndex();
        }
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        this.setPage(this.leftPage, this.analystPages.get(newLeftIndex));
        this.setPage(this.rightPage, this.analystPages.get(newRightIndex));
        this.analystPages.get(newLeftIndex).show();
        if (oldRightPercent != 0.0f) {
            this.leftPage.setPercentageIndex(oldRightPercent);
        }
        if (oldLeftPercent != 0.0f) {
            this.rightPage.setPercentageIndex(oldLeftPercent);
        }
    }

    public void setPage(ControlScrollableContent side, @Nullable IWidget page) {
        Control existingPage = (Control)side.getContent();
        if (existingPage != null) {
            existingPage.hide();
            side.setScrollableContent(null);
        }
        if (page != null) {
            page.show();
            side.setScrollableContent(page);
            side.setPercentageIndex(0.0f);
            page.setPosition(side.getPosition().add(1, 1));
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        super.onWindowInventoryChanged();
        WindowInventory inv = this.getWindowInventory();
        ItemStack stack = inv.func_70301_a(0);
        if (!stack.func_190926_b() && !ManagerGenetics.isAnalysed(stack)) {
            inv.func_70299_a(0, ManagerGenetics.analyse(stack, this.getWorld(), this.getUsername()));
            inv.func_70298_a(1, 1);
        }
        if (this.isClient()) {
            this.setStack(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setStack(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        this.setIndividual(ind);
    }

    public IIndividual getIndividual() {
        return this.current;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIndividual(@Nullable IIndividual ind) {
        if (!this.isDatabase) {
            if (ind == null) {
                this.analystNone.show();
                this.slideUpInv.hide();
            } else {
                this.analystNone.hide();
                this.slideUpInv.show();
            }
        }
        if (!(ind == this.current || ind != null && this.current != null && ind.isGeneticEqual(this.current))) {
            boolean systemChange;
            this.current = ind;
            boolean bl = systemChange = this.current != null && ind.getGenome().getSpeciesRoot() != this.getSystem().getSpeciesRoot();
            if (systemChange) {
                this.currentSystem = Binnie.GENETICS.getSystem(ind.getGenome().getSpeciesRoot());
            }
            this.updatePages(systemChange);
        }
    }

    public IBreedingSystem getSystem() {
        return this.currentSystem;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSystem(IBreedingSystem system) {
        if (system == this.currentSystem) {
            return;
        }
        this.currentSystem = system;
        this.current = null;
        this.updatePages(true);
    }

    public ControlScrollableContent getLeftPage() {
        return this.leftPage;
    }

    public void setLeftPage(ControlScrollableContent leftPage) {
        this.leftPage = leftPage;
    }

    public ControlScrollableContent getRightPage() {
        return this.rightPage;
    }

    public void setRightPage(ControlScrollableContent rightPage) {
        this.rightPage = rightPage;
    }

    public void setAnalystPageSize(IArea analystPageSize) {
        this.analystPageSize = analystPageSize;
    }

    public List<ITitledWidget> getAnalystPages() {
        return this.analystPages;
    }

    public boolean isDatabase() {
        return this.isDatabase;
    }

    @SideOnly(value=Side.CLIENT)
    private static class AnalystNoneControl
    extends Control {
        public AnalystNoneControl(WindowAnalyst windowAnalyst) {
            super(windowAnalyst.analystPanel, 0, 0, windowAnalyst.analystPanel.getWidth(), windowAnalyst.analystPanel.getHeight());
            new ControlTextCentered((IWidget)this, 20, I18N.localise("genetics.gui.analyst.desc")).setColor(0x444444);
            new ControlPlayerInventory(this);
        }
    }

    private static class AnalystSlotValidator
    extends SlotValidator.Individual {
        private final WindowAnalyst windowAnalyst;

        public AnalystSlotValidator(WindowAnalyst windowAnalyst) {
            this.windowAnalyst = windowAnalyst;
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            if (ManagerGenetics.isAnalysed(itemStack)) {
                return true;
            }
            if (ManagerGenetics.isAnalysable(itemStack)) {
                WindowInventory windowInventory = this.windowAnalyst.getWindowInventory();
                return !windowInventory.func_70301_a(1).func_190926_b();
            }
            return false;
        }
    }
}

