/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.proxy;

import binnie.core.models.ModelManager;
import binnie.extratrees.blocks.BlockETDecorativeLeaves;
import binnie.extratrees.blocks.BlockETDefaultLeaves;
import binnie.extratrees.blocks.BlockETDefaultLeavesFruit;
import binnie.extratrees.blocks.wood.BlockETSlab;
import binnie.extratrees.models.ModelDefaultETLeaves;
import binnie.extratrees.models.ModelDefaultETLeavesFruit;
import binnie.extratrees.models.ModelETDecorativeLeaves;
import binnie.extratrees.modules.ModuleWood;
import binnie.extratrees.proxy.IExtraTreeProxy;
import binnie.extratrees.proxy.Proxy;
import forestry.arboriculture.ModuleArboriculture;
import forestry.core.models.BlockModelEntry;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy
implements IExtraTreeProxy {
    public static final ModelManager modelManager = new ModelManager("extratrees");

    public static ModelManager getModelManager() {
        return modelManager;
    }

    @Override
    public void init() {
    }

    private static void registerBlockModel(BlockModelEntry index) {
        ModelManager.registerCustomBlockModel(index);
        if (index.addStateMapper) {
            BlockModeStateMapper ignoreState = new BlockModeStateMapper(index);
            ModelLoader.setCustomStateMapper((Block)index.block, (IStateMapper)ignoreState);
        }
    }

    @Override
    public void setCustomStateMapper(String name, Block block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new CustomMapper(name));
    }

    @Override
    public Item registerItem(Item item) {
        ProxyClient.getModelManager().registerItemClient(item);
        return super.registerItem(item);
    }

    @Override
    public Block registerBlock(Block block) {
        ProxyClient.getModelManager().registerBlockClient(block);
        return super.registerBlock(block);
    }

    @Override
    public void registerModels() {
        BlockModelEntry blockModelIndex;
        ModelResourceLocation itemModeLocation;
        ModelResourceLocation blockModelLocation;
        String resourceName;
        for (BlockETDecorativeLeaves blockETDecorativeLeaves : ModuleWood.leavesDecorative) {
            resourceName = blockETDecorativeLeaves.getRegistryName().toString();
            blockModelLocation = new ModelResourceLocation(resourceName);
            itemModeLocation = new ModelResourceLocation(resourceName, "inventory");
            blockModelIndex = new BlockModelEntry(blockModelLocation, itemModeLocation, (IBakedModel)new ModelETDecorativeLeaves(), (Block)blockETDecorativeLeaves);
            ProxyClient.registerBlockModel(blockModelIndex);
        }
        for (BlockETDefaultLeaves blockETDefaultLeaves : ModuleWood.leavesDefault) {
            resourceName = blockETDefaultLeaves.getRegistryName().toString();
            blockModelLocation = new ModelResourceLocation(resourceName);
            itemModeLocation = new ModelResourceLocation(resourceName, "inventory");
            blockModelIndex = new BlockModelEntry(blockModelLocation, itemModeLocation, (IBakedModel)new ModelDefaultETLeaves(), (Block)blockETDefaultLeaves);
            ProxyClient.registerBlockModel(blockModelIndex);
        }
        for (BlockETDefaultLeavesFruit blockETDefaultLeavesFruit : ModuleWood.leavesDefaultFruit) {
            resourceName = blockETDefaultLeavesFruit.getRegistryName().toString();
            blockModelLocation = new ModelResourceLocation(resourceName);
            itemModeLocation = new ModelResourceLocation(resourceName, "inventory");
            blockModelIndex = new BlockModelEntry(blockModelLocation, itemModeLocation, (IBakedModel)new ModelDefaultETLeavesFruit(), (Block)blockETDefaultLeavesFruit);
            ProxyClient.registerBlockModel(blockModelIndex);
        }
        for (BlockETSlab blockETSlab : ModuleWood.slabsDouble) {
            ModuleArboriculture.proxy.registerWoodModel((Block)blockETSlab, true);
        }
        for (BlockETSlab blockETSlab : ModuleWood.slabsDoubleFireproof) {
            ModuleArboriculture.proxy.registerWoodModel((Block)blockETSlab, true);
        }
        modelManager.registerModels();
    }

    @Override
    public void registerItemAndBlockColors() {
        ProxyClient.getModelManager().registerItemAndBlockColors();
    }

    private static class BlockModeStateMapper
    extends StateMapperBase {
        private final BlockModelEntry index;

        public BlockModeStateMapper(BlockModelEntry index) {
            this.index = index;
        }

        protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
            return this.index.blockModelLocation;
        }
    }

    static class CustomMapper
    extends StateMapperBase {
        private final ResourceLocation rl;

        public CustomMapper(String name) {
            this.rl = new ResourceLocation("extratrees", name);
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation(this.rl, this.func_178131_a((Map)state.func_177228_b()));
        }
    }
}

