/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.liquid;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum MiscFluid implements IFluidDefinition,
ICocktailLiquid
{
    CarbonatedWater("water.carbonated", 0xCCCCFF, (double)0.1f),
    TonicWater("water.tonic", 0xCCCCFF, (double)0.1f),
    Cream("cream", 0xEAEADE, 2.0),
    GingerAle("gingerAle", 0xFFFFFF, (double)0.6f),
    Coffee("coffee", 5910789, (double)0.3f),
    SugarSyrup("syrup.simple", 16120049, (double)0.1f),
    AgaveNectar("syrup.agave", 13598245, (double)0.7f),
    GrenadineSyrup("syrup.grenadine", 16009573, (double)0.8f);

    private final FluidType type;

    private MiscFluid(String ident, int color, double transparency) {
        this.type = new FluidType(ident, String.format("%s.fluid.%s.%s", ExtraTrees.instance.getModId(), "MiscFluid", this.name()), color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public String getDisplayName() {
        return this.type.getDisplayName();
    }

    @Override
    public String getIdentifier() {
        return this.type.getIdentifier();
    }

    @Override
    public int getColor() {
        return this.type.getColor();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }

    @Override
    public int getTransparency() {
        return this.type.getTransparency();
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getDisplayName();
    }

    @Override
    public float getABV() {
        return 0.0f;
    }

    @Override
    public FluidType getType() {
        return this.type;
    }
}

