/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.proxy;

import binnie.extrabees.items.IItemModelProvider;
import binnie.extrabees.modules.ModuleCore;
import binnie.extrabees.proxy.ExtraBeesCommonProxy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import forestry.core.models.BlankModel;
import forestry.core.models.ModelManager;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ExtraBeesClientProxy
extends ExtraBeesCommonProxy {
    private static final ModelManager modelManager = ModelManager.getInstance();

    public static ModelManager getModelManager() {
        return modelManager;
    }

    private static IBakedModel bakeModelFor(Block block) {
        return new BakedModelForBlock(block);
    }

    @Override
    public Item registerItem(Item item) {
        ExtraBeesClientProxy.getModelManager().registerItemClient(item);
        if (item instanceof IItemModelProvider) {
            ((IItemModelProvider)item).registerModel(item);
        }
        return super.registerItem(item);
    }

    @Override
    public Block registerBlock(Block block) {
        ExtraBeesClientProxy.getModelManager().registerBlockClient(block);
        return super.registerBlock(block);
    }

    @Override
    public void registerModel(@Nonnull Item item, int meta) {
        ResourceLocation registryName = item.getRegistryName();
        Preconditions.checkNotNull((Object)registryName);
        ModelResourceLocation inventory = new ModelResourceLocation(registryName, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)inventory);
    }

    @SubscribeEvent
    public void onModelsBaked(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        this.registerItemBlockLink(new ResourceLocation("extrabees", "ectoplasm"), ModuleCore.ectoplasm, (IRegistry<ModelResourceLocation, IBakedModel>)registry);
        this.registerItemBlockLink(new ResourceLocation("extrabees", "hive"), ModuleCore.hive, (IRegistry<ModelResourceLocation, IBakedModel>)registry);
    }

    private void registerItemBlockLink(ResourceLocation item, Block block, IRegistry<ModelResourceLocation, IBakedModel> registry) {
        registry.func_82595_a((Object)new ModelResourceLocation(item, "inventory"), (Object)ExtraBeesClientProxy.bakeModelFor(block));
    }

    private static class BakedModelForBlock
    extends BlankModel {
        private final Block block;

        public BakedModelForBlock(Block block) {
            this.block = block;
        }

        protected ItemOverrideList createOverrides() {
            return new BlockItemOverrideList(this.block);
        }

        private static class BlockItemOverrideList
        extends ItemOverrideList {
            private final Block block;

            public BlockItemOverrideList(Block block) {
                super((List)ImmutableList.of());
                this.block = block;
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                Minecraft minecraft = Minecraft.func_71410_x();
                BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
                BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
                IBlockState stateFromMeta = this.block.func_176203_a(stack.func_77960_j());
                return blockModelShapes.func_178125_b(stateFromMeta);
            }
        }
    }
}

