/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.init;

import binnie.core.Binnie;
import binnie.core.Mods;
import binnie.core.util.RecipeUtil;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.items.types.EnumHoneyDrop;
import binnie.extrabees.items.types.EnumPropolis;
import binnie.extrabees.items.types.ExtraBeeItems;
import binnie.extrabees.modules.ModuleCore;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public final class RecipeRegister {
    private static final RecipeUtil RECIPE_UTIL = new RecipeUtil("extrabees");

    public static void doInitRecipes() {
        if (Loader.isModLoaded((String)"ic2")) {
            RECIPE_UTIL.addRecipe("honey_crystal", ModuleCore.honeyCrystal.getCharged(0.0), "#@#", "@#@", "#@#", Character.valueOf('@'), Mods.Forestry.item("honey_drop"), Character.valueOf('#'), EnumHoneyDrop.ENERGY.get(1));
        }
        for (EnumHoneyComb enumHoneyComb : EnumHoneyComb.values()) {
            enumHoneyComb.addRecipe();
        }
        for (Enum enum_ : EnumHoneyDrop.values()) {
            ((EnumHoneyDrop)enum_).addRecipe();
        }
        for (Enum enum_ : EnumPropolis.values()) {
            ((EnumPropolis)enum_).addRecipe();
        }
        RecipeRegister.addForestryRecipes();
        RecipeRegister.addMiscItemRecipes();
    }

    private static void addForestryRecipes() {
        RecipeManagers.carpenterManager.addRecipe(100, Binnie.LIQUID.getFluidStack("water", 2000), ItemStack.field_190927_a, new ItemStack(ModuleCore.dictionaryBees), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('E'), Items.field_151166_bC});
    }

    private static void addMiscItemRecipes() {
        ItemStack lapisShard = ExtraBeeItems.LAPIS_SHARD.get(1);
        RECIPE_UTIL.addShapelessRecipe("lapis_from_shards", new ItemStack(Items.field_151100_aR, 1, 4), lapisShard, lapisShard, lapisShard, lapisShard);
        for (ExtraBeeItems item : ExtraBeeItems.values()) {
            if (item.metalString != null) {
                ItemStack dust = null;
                ItemStack ingot = null;
                if (!OreDictionary.getOres((String)("ingot" + item.metalString)).isEmpty()) {
                    ingot = ((ItemStack)OreDictionary.getOres((String)("ingot" + item.metalString)).get(0)).func_77946_l();
                }
                if (!OreDictionary.getOres((String)("dust" + item.metalString)).isEmpty()) {
                    dust = ((ItemStack)OreDictionary.getOres((String)("dust" + item.metalString)).get(0)).func_77946_l();
                }
                ItemStack input = item.get(1);
                if (dust != null) {
                    RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_dust", dust, input, input, input, input);
                    continue;
                }
                if (ingot != null) {
                    RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_ingot", ingot, input, input, input, input, input, input, input, input, input);
                    continue;
                }
                if (item != ExtraBeeItems.COAL_DUST) continue;
                RECIPE_UTIL.addShapelessRecipe("coal_dust_to_coal", new ItemStack(Items.field_151044_h), input, input, input, input);
                continue;
            }
            if (item.gemString == null) continue;
            ItemStack gem = null;
            if (!OreDictionary.getOres((String)("gem" + item.gemString)).isEmpty()) {
                gem = (ItemStack)OreDictionary.getOres((String)("gem" + item.gemString)).get(0);
            }
            ItemStack input2 = item.get(1);
            if (gem == null) continue;
            RECIPE_UTIL.addShapelessRecipe(item.getModelPath() + "_gem", gem.func_77946_l(), input2, input2, input2, input2, input2, input2, input2, input2, input2);
        }
        Item woodGear = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("buildcraftcore", "gear_wood"));
        ItemStack gear = woodGear != null ? new ItemStack(woodGear, 1) : new ItemStack(Blocks.field_150344_f, 1);
        RecipeManagers.carpenterManager.addRecipe(100, Fluids.FOR_HONEY.getFluid(500), ItemStack.field_190927_a, ExtraBeeItems.SCENTED_GEAR.get(1), new Object[]{" j ", "bgb", " p ", Character.valueOf('j'), Mods.Forestry.item("royal_jelly"), Character.valueOf('b'), Mods.Forestry.item("beeswax"), Character.valueOf('p'), Mods.Forestry.item("pollen"), Character.valueOf('g'), gear});
    }
}

