/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileUtil {
    @Nullable
    public static <T> T getTile(IBlockAccess world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    public static <T> void actOnTile(IBlockAccess world, BlockPos pos, Class<T> tileClass, ITileAction<T> tileAction) {
        T tile = TileUtil.getTile(world, pos, tileClass);
        if (tile != null) {
            tileAction.actOnTile(tile);
        }
    }

    @Nullable
    public static <T> T getCapability(World world, BlockPos pos, Capability<T> capability, EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(capability, facing)) {
            return (T)tileEntity.getCapability(capability, facing);
        }
        return null;
    }

    public static interface ITileAction<T> {
        public void actOnTile(T var1);
    }
}

