/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.util;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NBTUtil {
    private NBTUtil() {
    }

    public static void readFromList(NBTTagCompound compound, String listKey, Consumer<NBTTagCompound> consumer) {
        if (!compound.func_150297_b(listKey, 9)) {
            return;
        }
        NBTTagList tagList = compound.func_150295_c(listKey, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            consumer.accept(tagList.func_150305_b(i));
        }
    }

    public static <K, V> void writeToList(NBTTagCompound compound, String listKey, Map<K, V> content, BiFunction<K, V, NBTTagCompound> consumer) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<K, V> entry : content.entrySet()) {
            tagList.func_74742_a((NBTBase)consumer.apply(entry.getKey(), entry.getValue()));
        }
        compound.func_74782_a(listKey, (NBTBase)tagList);
    }

    public static void readFromNBT(IEnergyStorage storage, String key, NBTTagCompound nbt) {
        if (nbt.func_74764_b(key)) {
            CapabilityEnergy.ENERGY.readNBT((Object)storage, null, nbt.func_74781_a(key));
        }
    }

    public static void writeToNBT(IEnergyStorage storage, String key, NBTTagCompound nbt) {
        NBTBase nbtBase = CapabilityEnergy.ENERGY.writeNBT((Object)storage, null);
        if (nbtBase != null) {
            nbt.func_74782_a(key, nbtBase);
        }
    }
}

