/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.packet.MessageBase;
import binnie.core.util.Log;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class MessageBinnie
implements IMessage {
    private int id;
    private ByteBuf data;
    private MessageBase message;

    public MessageBinnie() {
    }

    public MessageBinnie(int id, MessageBase base) {
        this.id = id;
        this.message = base;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.id);
        try {
            this.message.writeData(buf);
        }
        catch (IOException e) {
            Log.error("Failed to write message data.", e);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readByte();
        this.data = buf.retain();
    }

    public int getId() {
        return this.id;
    }

    public ByteBuf getData() {
        return this.data;
    }
}

