/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.transfer;

import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.transfer.TransferResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TransferRequest {
    private ItemStack returnItem = ItemStack.field_190927_a;
    @Nullable
    private IInventory origin;
    @Nullable
    private IInventory destination;
    private int[] targetSlots = new int[0];
    private int[] targetTanks = new int[0];
    private boolean transferLiquids = true;
    private boolean ignoreReadOnly = false;
    private final List<TransferSlot> insertedSlots = new ArrayList<TransferSlot>();

    public TransferRequest(ItemStack toTransfer, IInventory destination) {
        int[] target = new int[destination.func_70302_i_()];
        for (int i = 0; i < target.length; ++i) {
            target[i] = i;
        }
        int[] targetTanks = new int[]{};
        if (destination instanceof ITankMachine) {
            targetTanks = new int[((ITankMachine)destination).getTanks().length];
            for (int j = 0; j < targetTanks.length; ++j) {
                targetTanks[j] = j;
            }
        }
        if (!toTransfer.func_190926_b()) {
            this.setReturnItem(toTransfer.func_77946_l());
        }
        this.setOrigin(null);
        this.setDestination(destination);
        this.setTargetSlots(target);
        this.setTargetTanks(targetTanks);
    }

    private static boolean areItemsEqual(ItemStack merged, ItemStack itemstack) {
        return ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)merged) && itemstack.func_77969_a(merged);
    }

    public static NonNullList<ItemStack> mergeStacks(ItemStack itemstack, ItemStack merged) {
        int space;
        if (TransferRequest.areItemsEqual(itemstack, merged) && (space = merged.func_77976_d() - merged.func_190916_E()) > 0) {
            if (itemstack.func_190916_E() > space) {
                itemstack.func_190918_g(space);
                merged.func_190917_f(space);
            } else if (itemstack.func_190916_E() <= space) {
                merged.func_190917_f(itemstack.func_190916_E());
                itemstack = ItemStack.field_190927_a;
            }
        }
        NonNullList result = NonNullList.func_191196_a();
        result.add((Object)itemstack);
        result.add((Object)merged);
        return result;
    }

    public TransferRequest ignoreValidation() {
        this.ignoreReadOnly = true;
        return this;
    }

    private void setReturnItem(ItemStack returnItem) {
        this.returnItem = returnItem;
    }

    public TransferResult transfer(@Nullable EntityPlayer player, boolean doAdd) {
        InventorySlot inventorySlot;
        ITankMachine tankMachine;
        IFluidHandler fluidHandler;
        ItemStack item = this.returnItem;
        if (item.func_190926_b() || this.destination == null) {
            return TransferResult.FAILURE;
        }
        if (this.transferLiquids && this.destination instanceof ITankMachine && item.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidHandler = (tankMachine = (ITankMachine)this.destination).getHandler(this.targetTanks)) != null) {
            FluidActionResult fluidActionResult;
            ItemStack singleCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1);
            if (this.origin != null && doAdd) {
                InvWrapper itemHandler = new InvWrapper(this.origin);
                fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)singleCopy, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)1000, (EntityPlayer)player, (boolean)doAdd);
                if (!fluidActionResult.isSuccess()) {
                    fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)singleCopy, (IFluidHandler)fluidHandler, (IItemHandler)itemHandler, (int)1000, (EntityPlayer)player, (boolean)doAdd);
                }
            } else {
                fluidActionResult = FluidUtil.tryEmptyContainer((ItemStack)singleCopy, (IFluidHandler)fluidHandler, (int)1000, (EntityPlayer)player, (boolean)doAdd);
                if (!fluidActionResult.isSuccess()) {
                    fluidActionResult = FluidUtil.tryFillContainer((ItemStack)singleCopy, (IFluidHandler)fluidHandler, (int)1000, (EntityPlayer)player, (boolean)doAdd);
                }
            }
            if (fluidActionResult.isSuccess()) {
                if (item.func_190916_E() == 1) {
                    return new TransferResult(fluidActionResult.result);
                }
                ItemStack itemCopy = item.func_77946_l();
                itemCopy.func_190918_g(1);
                return new TransferResult(fluidActionResult.result, itemCopy);
            }
            return TransferResult.FAILURE;
        }
        if (!item.func_190926_b()) {
            for (int slot : this.targetSlots) {
                ItemStack stackInSlot;
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && (inventorySlot = ((IInventorySlots)this.destination).getSlot(slot)) != null && inventorySlot.isRecipe() || (stackInSlot = this.destination.func_70301_a(slot)).func_190926_b() || !item.func_77985_e()) continue;
                ItemStack merged = stackInSlot.func_77946_l();
                NonNullList<ItemStack> newStacks = TransferRequest.mergeStacks(item.func_77946_l(), merged.func_77946_l());
                item = (ItemStack)newStacks.get(0);
                if (!TransferRequest.areItemsEqual(merged, (ItemStack)newStacks.get(1))) {
                    this.insertedSlots.add(new TransferSlot(slot, this.destination));
                }
                if (doAdd) {
                    this.destination.func_70299_a(slot, (ItemStack)newStacks.get(1));
                }
                if (!item.func_190926_b()) continue;
                return new TransferResult(ItemStack.field_190927_a);
            }
        }
        if (!item.func_190926_b()) {
            for (int slot : this.targetSlots) {
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && (inventorySlot = ((IInventorySlots)this.destination).getSlot(slot)) != null && inventorySlot.isRecipe() || !this.destination.func_70301_a(slot).func_190926_b()) continue;
                this.insertedSlots.add(new TransferSlot(slot, this.destination));
                if (doAdd) {
                    this.destination.func_70299_a(slot, item.func_77946_l());
                }
                return new TransferResult(ItemStack.field_190927_a);
            }
        }
        this.setReturnItem(item);
        return new TransferResult(item);
    }

    public List<TransferSlot> getInsertedSlots() {
        return this.insertedSlots;
    }

    @Nullable
    public IInventory getOrigin() {
        return this.origin;
    }

    public TransferRequest setOrigin(@Nullable IInventory origin) {
        this.origin = origin;
        return this;
    }

    @Nullable
    public IInventory getDestination() {
        return this.destination;
    }

    private void setDestination(IInventory destination) {
        this.destination = destination;
    }

    public TransferRequest setTargetSlots(int[] targetSlots) {
        this.targetSlots = targetSlots;
        return this;
    }

    public TransferRequest setTargetTanks(int ... targetTanks) {
        this.targetTanks = targetTanks;
        return this;
    }

    public static class TransferSlot {
        private final int id;
        private final IInventory inventory;

        public TransferSlot(int id, IInventory inventory) {
            this.id = id;
            this.inventory = inventory;
        }

        public int getId() {
            return this.id;
        }

        public IInventory getInventory() {
            return this.inventory;
        }
    }
}

