/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gui.database;

import binnie.botany.Botany;
import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.botany.api.genetics.IFlowerColor;
import binnie.botany.gui.database.ControlColorOption;
import binnie.botany.gui.database.PageColorMix;
import binnie.botany.gui.database.PageColorMixResultant;
import binnie.botany.gui.database.PageSpeciesFlowerGenome;
import binnie.botany.modules.ModuleFlowers;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.ModeWidgets;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.core.util.I18N;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowBotanistDatabase
extends WindowAbstractDatabase {
    public WindowBotanistDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, ModuleFlowers.flowerBreedingSystem, 130);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowBotanistDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.overview"));
        new PageSpeciesFlowerGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "genome.title"));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.classification"));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.resultant"));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Botany.instance, "species.further"));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Botany.instance, "branches.overview"));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Botany.instance, "branches.species"));
        this.createMode(FlowerMode.Color, new ModeWidgets(FlowerMode.Color, this, (area, modePage) -> {
            FlowerColorControlListBox listBox = new FlowerColorControlListBox(modePage, area);
            List colors = Arrays.stream(EnumFlowerColor.values()).map(EnumFlowerColor::getFlowerColorAllele).collect(Collectors.toList());
            listBox.setOptions(colors);
            return listBox;
        }));
        new PageColorMixResultant((IWidget)this.getInfoPages(FlowerMode.Color), new DatabaseTab(Botany.instance, "color.resultant"));
        new PageColorMix((IWidget)this.getInfoPages(FlowerMode.Color), new DatabaseTab(Botany.instance, "color.further"));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(Botany.instance, "breeder"));
    }

    @Override
    protected String getModId() {
        return Botany.instance.getModId();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "FlowerDatabase";
    }

    @SideOnly(value=Side.CLIENT)
    private static class FlowerColorControlListBox
    extends ControlListBox<IFlowerColor> {
        public FlowerColorControlListBox(ControlPage<IDatabaseMode> modePage, IArea area) {
            super(modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12);
        }

        @Override
        public IWidget createOption(IFlowerColor value, int y) {
            return new ControlColorOption((ControlList)this.getContent(), value, y);
        }
    }

    static enum FlowerMode implements IDatabaseMode
    {
        Color;


        @Override
        public String getName() {
            return I18N.localise("botany.gui.database.tab." + this.name().toLowerCase());
        }
    }
}

