/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.vec;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleBlockTransformer {
    public static void flipTE(TileEntityLittleTiles te, EnumFacing.Axis axis, boolean connected) {
        if (axis == null) {
            return;
        }
        for (LittleTile tile : te) {
            LittleBlockTransformer.flipTile(tile, axis, connected);
        }
    }

    public static void rotateTE(TileEntityLittleTiles te, Rotation rotation, int steps, boolean connected) {
        if (rotation == null) {
            return;
        }
        for (LittleTile tile : te) {
            for (int rotationStep = 0; rotationStep < steps; ++rotationStep) {
                LittleBlockTransformer.rotateTile(tile, rotation, connected);
            }
        }
    }

    public static void flipTile(LittleTile tile, EnumFacing.Axis axis, boolean connected) {
        LittleVec moved = tile.box.getMinVec();
        tile.box.flipBox(axis, tile.getContext().rotationCenter);
        moved.sub(tile.box.getMinVec());
        if (!connected && tile.isChildOfStructure() && !tile.connection.isLink()) {
            LittleBlockTransformer.flipStructure(tile.connection.getStructureWithoutLoading(), axis, moved);
        }
    }

    public static void rotateTile(LittleTile tile, Rotation rotation, boolean connected) {
        LittleVec moved = tile.box.getMinVec();
        tile.box.rotateBox(rotation, tile.getContext().rotationCenter);
        moved.sub(tile.box.getMinVec());
        if (!connected && tile.isChildOfStructure() && !tile.connection.isLink()) {
            LittleBlockTransformer.rotateStructure(tile.connection.getStructureWithoutLoading(), rotation, moved);
        }
    }

    public static void flipStructure(LittleStructure structure, EnumFacing.Axis axis, LittleVec moved) {
        BlockPos mainPos = structure.getMainTile().te.func_174877_v();
        if (structure.tilesToLoad != null) {
            LinkedHashMap<BlockPos, Integer> newTilesToLoad = new LinkedHashMap<BlockPos, Integer>();
            for (Map.Entry<BlockPos, Integer> entry : structure.tilesToLoad.entrySet()) {
                BlockPos pos = entry.getKey();
                pos = pos.func_177973_b((Vec3i)mainPos);
                pos = RotationUtils.flip((BlockPos)pos, (EnumFacing.Axis)axis);
                pos = pos.func_177971_a((Vec3i)mainPos);
                newTilesToLoad.put(pos, entry.getValue());
            }
            structure.tilesToLoad = newTilesToLoad;
            structure.blockTiles().clear();
        }
        LittleGridContext context = structure.getMainTile().getContext();
        LittleVec center = context.rotationCenter.copy();
        LittleVec offset = structure.getMainTile().getMinVec();
        offset.scale(2);
        center.sub(offset);
        for (StructureDirectionalField relative : structure.type.directional) {
            Object value = relative.get(structure);
            relative.move(value, context, moved);
            relative.flip(value, context, axis, center);
        }
    }

    public static void rotateStructure(LittleStructure structure, Rotation rotation, LittleVec moved) {
        BlockPos mainPos = structure.getMainTile().te.func_174877_v();
        if (structure.tilesToLoad != null) {
            LinkedHashMap<BlockPos, Integer> newTilesToLoad = new LinkedHashMap<BlockPos, Integer>();
            for (Map.Entry<BlockPos, Integer> entry : structure.tilesToLoad.entrySet()) {
                BlockPos pos = entry.getKey();
                pos = pos.func_177973_b((Vec3i)mainPos);
                pos = RotationUtils.rotate((BlockPos)pos, (Rotation)rotation);
                pos = pos.func_177971_a((Vec3i)mainPos);
                newTilesToLoad.put(pos, entry.getValue());
            }
            structure.tilesToLoad = newTilesToLoad;
            structure.blockTiles().clear();
        }
        LittleGridContext context = structure.getMainTile().getContext();
        LittleVec center = context.rotationCenter.copy();
        LittleVec offset = structure.getMainTile().getMinVec();
        offset.scale(2);
        center.sub(offset);
        for (StructureDirectionalField relative : structure.type.directional) {
            Object value = relative.get(structure);
            relative.move(value, context, moved);
            relative.rotate(value, context, rotation, center);
        }
    }
}

