/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlacementPosition
extends LittleAbsoluteVec {
    public EnumFacing facing;
    @SideOnly(value=Side.CLIENT)
    public List<LittleRenderingCube> positingCubes;

    public PlacementPosition(BlockPos pos, LittleVecContext vec, EnumFacing facing) {
        super(pos, vec);
        this.facing = facing;
    }

    public PlacementPosition(BlockPos pos, LittleGridContext context, LittleVec vec, EnumFacing facing) {
        super(pos, context, vec);
        this.facing = facing;
    }

    public static PlacementPosition readFromBytes(ByteBuf buf) {
        return new PlacementPosition(LittleAction.readPos((ByteBuf)buf), LittleAction.readLittleVecContext(buf), CreativeCorePacket.readFacing((ByteBuf)buf));
    }

    public void assign(LittleAbsoluteVec pos) {
        this.pos = pos.getPos();
        this.contextVec = pos.getVecContext();
    }

    public AxisAlignedBB getBox() {
        double x = this.getPosX();
        double y = this.getPosY();
        double z = this.getPosZ();
        return new AxisAlignedBB(x, y, z, x + this.getContext().pixelSize, y + this.getContext().pixelSize, z + this.getContext().pixelSize);
    }

    public void subVec(LittleVec vec) {
        this.getVec().add(vec);
        this.removeInternalBlockOffset();
    }

    public void addVec(LittleVec vec) {
        this.getVec().sub(vec);
        this.removeInternalBlockOffset();
    }

    public void writeToBytes(ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)this.pos);
        LittleAction.writeLittleVecContext(this.contextVec, buf);
        CreativeCorePacket.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
    }

    @Override
    public PlacementPosition copy() {
        return new PlacementPosition(this.pos, this.contextVec.copy(), this.facing);
    }
}

