/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.fixed.InsideFixedHandler;
import com.creativemd.littletiles.common.tile.place.fixed.SecondModeHandler;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlacementHelper {
    private static boolean lastLowResolution;
    private static NBTTagCompound lastCached;
    private static LittlePreviews lastPreviews;

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).hasLittlePreview(stack);
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).hasLittlePreview(stack);
        }
        return false;
    }

    public static LittleVec getInternalOffset(ILittleTile iTile, ItemStack stack, LittlePreviews tiles, LittleGridContext original) {
        LittleVec offset = iTile.getCachedOffset(stack);
        if (offset != null) {
            if (tiles.getContext() != original) {
                offset.convertTo(original, tiles.getContext());
            }
            return offset;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittlePreview preview : tiles.allPreviews()) {
            if (preview.box == null) continue;
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
        }
        return new LittleVec(minX, minY, minZ);
    }

    public static LittleVec getSize(ILittleTile iTile, ItemStack stack, LittlePreviews tiles, boolean allowLowResolution, LittleGridContext original) {
        LittleVec cached = iTile.getCachedSize(stack);
        if (cached != null) {
            if (tiles.getContext() != original) {
                cached.convertTo(original, tiles.getContext());
            }
            return cached;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LittleVec size = new LittleVec(0, 0, 0);
        for (LittlePreview preview : tiles.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public static void removeCache() {
        lastCached = null;
        lastPreviews = null;
        lastLowResolution = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static PlacementPosition getPosition(World world, RayTraceResult moving, LittleGridContext context, ILittleTile tile, ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int x = moving.func_178782_a().func_177958_n();
        int y = moving.func_178782_a().func_177956_o();
        int z = moving.func_178782_a().func_177952_p();
        boolean canBePlacedInsideBlock = true;
        if (!PlacementHelper.canBePlacedInside(world, moving.func_178782_a(), moving.field_72307_f, moving.field_178784_b)) {
            switch (moving.field_178784_b) {
                case EAST: {
                    ++x;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    break;
                }
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
            }
            canBePlacedInsideBlock = false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        PlacementPosition result = new PlacementPosition(pos, PlacementHelper.getHitVec(moving, context, canBePlacedInsideBlock).getVecContext(), moving.field_178784_b);
        if (tile != null && stack != null && LittleAction.isUsingSecondMode((EntityPlayer)player) != tile.snapToGridByDefault()) {
            Vec3d position = player.func_174824_e(TickUtils.getPartialTickTime());
            double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
            Vec3d temp = player.func_70676_i(TickUtils.getPartialTickTime());
            Vec3d look = position.func_72441_c(temp.field_72450_a * d0, temp.field_72448_b * d0, temp.field_72449_c * d0);
            position = position.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            look = look.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            List<LittleRenderingCube> cubes = tile.getPositingCubes(world, pos, stack);
            if (cubes != null) {
                result.positingCubes = cubes;
            }
        }
        return result;
    }

    public static PlacementPreview getPreviews(World world, ItemStack stack, PlacementPosition position, boolean centered, boolean fixed, boolean allowLowResolution, boolean marked, PlacementMode mode) {
        PlacementPreview result;
        LittlePreviews tiles;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        LittlePreviews littlePreviews = tiles = allowLowResolution == lastLowResolution && iTile.shouldCache() && lastCached != null && lastCached.equals((Object)stack.func_77978_p()) ? lastPreviews.copy() : null;
        if (tiles == null && iTile != null) {
            tiles = iTile.getLittlePreview(stack, allowLowResolution, marked);
        }
        if ((result = PlacementHelper.getPreviews(world, tiles, iTile.getPreviewsContext(stack), stack, position, centered, fixed, allowLowResolution, mode)) != null) {
            if (stack.func_77978_p() == null) {
                lastCached = null;
                lastPreviews = null;
            } else {
                lastLowResolution = allowLowResolution;
                lastCached = stack.func_77978_p().func_74737_b();
                lastPreviews = tiles.copy();
            }
        }
        return result;
    }

    public static PlacementPreview getAbsolutePreviews(World world, LittlePreviews previews, BlockPos pos, PlacementMode mode) {
        return new PlacementPreview(world, previews, mode, previews.getSurroundingBox(), true, pos, null, null);
    }

    public static PlacementPreview getPreviews(World world, @Nullable LittlePreviews tiles, LittleGridContext original, ItemStack stack, PlacementPosition position, boolean centered, boolean fixed, boolean allowLowResolution, PlacementMode mode) {
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        if (tiles != null && (!tiles.isEmpty() || tiles.hasChildren())) {
            boolean singleMode;
            if (tiles.isAbsolute()) {
                return new PlacementPreview(world, tiles, mode, tiles.getSurroundingBox(), true, tiles.getBlockPos(), null, position.facing);
            }
            tiles.forceContext(position);
            LittleGridContext context = tiles.getContext();
            LittleVec size = PlacementHelper.getSize(iTile, stack, tiles, allowLowResolution, original);
            ArrayList<InsideFixedHandler> shifthandlers = new ArrayList<InsideFixedHandler>();
            boolean bl = singleMode = tiles.size() == 1;
            if (singleMode) {
                shifthandlers.add(new InsideFixedHandler());
                centered = true;
            }
            LittleBox box = PlacementHelper.getTilesBox(position, size, centered, position.facing, mode);
            boolean canBePlaceFixed = false;
            if (fixed && !singleMode && !(canBePlaceFixed = LittleAction.canPlaceInside(tiles, world, position.getPos(), mode.placeInside))) {
                for (int i = 0; i < shifthandlers.size(); ++i) {
                    box = ((SecondModeHandler)shifthandlers.get(i)).getBox(world, position.getPos(), context, box);
                }
            }
            LittleAbsoluteVec offset = new LittleAbsoluteVec(position.getPos(), context, box.getMinVec());
            LittleVec internalOffset = PlacementHelper.getInternalOffset(iTile, stack, tiles, original);
            internalOffset.invert();
            offset.getVec().add(internalOffset);
            if ((canBePlaceFixed || fixed && singleMode) && mode.placeInside && position.getVec().get(position.facing.func_176740_k()) % context.size == 0) {
                offset.getVec().add(position.facing.func_176734_d());
            }
            return new PlacementPreview(world, tiles, mode, box, canBePlaceFixed, offset.getPos(), offset.getVec(), position.facing);
        }
        return null;
    }

    public static LittleBox getTilesBox(LittleAbsoluteVec pos, LittleVec size, boolean centered, @Nullable EnumFacing facing, PlacementMode mode) {
        LittleVec temp = pos.getVec().copy();
        if (centered) {
            LittleVec center = size.calculateCenter();
            LittleVec centerInv = size.calculateInvertedCenter();
            if (mode.placeInside) {
                facing = facing.func_176734_d();
            }
            switch (facing) {
                case EAST: {
                    temp.x += center.x;
                    break;
                }
                case WEST: {
                    temp.x -= centerInv.x;
                    break;
                }
                case UP: {
                    temp.y += center.y;
                    break;
                }
                case DOWN: {
                    temp.y -= centerInv.y;
                    break;
                }
                case SOUTH: {
                    temp.z += center.z;
                    break;
                }
                case NORTH: {
                    temp.z -= centerInv.z;
                    break;
                }
            }
        }
        return new LittleBox(temp, size.x, size.y, size.z);
    }

    public static boolean canBlockBeUsed(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return true;
        }
        return ChiselsAndBitsManager.isChiselsAndBitsStructure(tileEntity);
    }

    public static boolean canBePlacedInside(World world, BlockPos pos, Vec3d hitVec, EnumFacing side) {
        if (PlacementHelper.canBlockBeUsed(world, pos)) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return (double)((int)hitVec.field_72450_a) != hitVec.field_72450_a;
                }
                case UP: 
                case DOWN: {
                    return (double)((int)hitVec.field_72448_b) != hitVec.field_72448_b;
                }
                case SOUTH: 
                case NORTH: {
                    return (double)((int)hitVec.field_72449_c) != hitVec.field_72449_c;
                }
            }
            return false;
        }
        return false;
    }

    public static LittleAbsoluteVec getHitVec(RayTraceResult result, LittleGridContext context, boolean isInsideOfBlock) {
        LittleAbsoluteVec pos = new LittleAbsoluteVec(result, context);
        if (!isInsideOfBlock) {
            pos.getVec().set(result.field_178784_b.func_176740_k(), result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : context.size);
        }
        return pos;
    }
}

