/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Placement {
    public final EntityPlayer player;
    public final World world;
    public final PlacementMode mode;
    public final BlockPos pos;
    public final EnumFacing facing;
    public final LittlePreviews previews;
    public final LinkedHashMap<BlockPos, PlacementBlock> blocks = new LinkedHashMap();
    public final PlacementStructurePreview origin;
    public final List<PlacementStructurePreview> structures = new ArrayList<PlacementStructurePreview>();
    public final List<LittleTile> removedTiles = new ArrayList<LittleTile>();
    public final List<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
    public final List<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
    protected ItemStack stack;
    protected boolean ignoreWorldBoundaries = true;
    protected Predicate<LittleTile> predicate;

    public Placement(EntityPlayer player, PlacementPreview preview) {
        this.player = player;
        this.world = preview.world;
        this.mode = preview.mode;
        this.pos = preview.pos;
        this.facing = preview.facing;
        this.previews = preview.previews;
        this.origin = this.createStructureTree(null, preview.previews);
        this.createPreviews(this.origin, preview.inBlockOffset, preview.pos);
        for (PlacementBlock block : this.blocks.values()) {
            block.convertToSmallest();
        }
    }

    public Placement setIgnoreWorldBoundaries(boolean value) {
        this.ignoreWorldBoundaries = value;
        return this;
    }

    public Placement setPredicate(Predicate<LittleTile> predicate) {
        this.predicate = predicate;
        return this;
    }

    public Placement setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public boolean canPlace() {
        for (BlockPos pos : this.blocks.keySet()) {
            if (LittleAction.isAllowedToInteract(this.world, this.player, pos, true, EnumFacing.EAST)) continue;
            LittleAction.sendBlockResetToClient(this.world, (EntityPlayerMP)this.player, pos);
            return false;
        }
        List<BlockPos> coordsToCheck = this.mode.getCoordsToCheck(this.blocks.keySet(), this.pos);
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacementBlock block = this.blocks.get(pos);
                if (block == null || block.canPlace()) continue;
                return false;
            }
        }
        return true;
    }

    public PlacementResult place() throws LittleActionException {
        if (this.player != null && !this.world.field_72995_K) {
            if (this.player != null) {
                if (LittleTiles.CONFIG.isPlaceLimited(this.player) && this.previews.getVolumeIncludingChildren() > (double)LittleTiles.CONFIG.survival.maxPlaceBlocks) {
                    throw new LittleTilesConfig.NotAllowedToPlaceException();
                }
                if (LittleTiles.CONFIG.isTransparencyRestricted(this.player)) {
                    for (Object preview : this.previews) {
                        LittleAction.isAllowedToPlacePreview(this.player, (LittlePreview)preview);
                    }
                }
            }
            ArrayList<BlockSnapshot> snaps = new ArrayList<BlockSnapshot>();
            for (BlockPos snapPos : this.blocks.keySet()) {
                snaps.add(new BlockSnapshot(this.world, snapPos, BlockTile.getState(false, false)));
            }
            BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(snaps, this.world.func_180495_p(this.facing == null ? this.pos : this.pos.func_177972_a(this.facing)), this.player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                for (BlockPos snapPos : this.blocks.keySet()) {
                    LittleAction.sendBlockResetToClient(this.world, (EntityPlayerMP)this.player, this.pos);
                }
                return null;
            }
        }
        if (this.canPlace()) {
            return this.placeTiles();
        }
        return null;
    }

    public PlacementResult tryPlace() {
        try {
            return this.place();
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected PlacementResult placeTiles() throws LittleActionException {
        void var4_10;
        PlacementResult result = new PlacementResult(this.pos, this.origin.structure);
        for (PlacementBlock block : this.blocks.values()) {
            block.place(result);
        }
        HashSet<BlockPos> blocksToUpdate = new HashSet<BlockPos>(this.blocks.keySet());
        Iterator<PlacementBlock> iterator = this.blocks.values().iterator();
        while (iterator.hasNext()) {
            PlacementBlock placementBlock = iterator.next();
            if (!placementBlock.combineTilesSecretly()) continue;
            result.tileEntities.remove(placementBlock.cached);
            iterator.remove();
        }
        for (PlacementBlock placementBlock : this.blocks.values()) {
            placementBlock.placeLate();
        }
        if (this.origin.structure != null) {
            if (this.origin.structure.getMainTile() == null) {
                throw new LittleActionException("Missing maintile of structure. Placed " + result.placedPreviews.size() + " tile(s).");
            }
            this.notifyStructurePlaced();
        }
        this.constructStructureRelations();
        HashSet<BlockPos> blocksToNotify = new HashSet<BlockPos>();
        for (BlockPos pos : blocksToUpdate) {
            for (int i = 0; i < 6; ++i) {
                BlockPos neighbour = pos.func_177972_a(EnumFacing.field_82609_l[i]);
                if (blocksToNotify.contains(neighbour) || blocksToUpdate.contains(neighbour)) continue;
                blocksToNotify.add(neighbour);
            }
            TileEntity te = this.world.func_175625_s(pos);
            if (te instanceof TileEntityLittleTiles) {
                ((TileEntityLittleTiles)te).updateTiles(false);
            }
            this.world.func_180495_p(pos).func_189546_a(this.world, pos, LittleTiles.blockTileNoTicking, this.pos);
        }
        for (BlockPos pos : blocksToNotify) {
            this.world.func_180495_p(pos).func_189546_a(this.world, pos, LittleTiles.blockTileNoTicking, this.pos);
        }
        boolean bl = false;
        while (var4_10 < this.soundsToBePlayed.size()) {
            this.world.func_184133_a((EntityPlayer)null, this.pos, this.soundsToBePlayed.get((int)var4_10).func_185841_e(), SoundCategory.BLOCKS, (this.soundsToBePlayed.get((int)var4_10).func_185843_a() + 1.0f) / 2.0f, this.soundsToBePlayed.get((int)var4_10).func_185847_b() * 0.8f);
            ++var4_10;
        }
        return result;
    }

    public void notifyStructurePlaced() {
        this.origin.structure.placedStructure(this.stack);
    }

    public void constructStructureRelations() {
        this.updateRelations(this.origin);
    }

    private void updateRelations(PlacementStructurePreview preview) {
        for (int i = 0; i < preview.children.size(); ++i) {
            PlacementStructurePreview child = preview.children.get(i);
            if (preview.structure != null && child.structure != null) {
                preview.structure.updateChildConnection(i, child.structure);
                child.structure.updateParentConnection(i, preview.structure);
            }
            this.updateRelations(child);
        }
    }

    public PlacementBlock getorCreateBlock(BlockPos pos) {
        PlacementBlock block = this.blocks.get(pos);
        if (block == null) {
            block = new PlacementBlock(pos, this.previews.getContext());
            this.blocks.put(pos, block);
        }
        return block;
    }

    private PlacementStructurePreview createStructureTree(PlacementStructurePreview parent, LittlePreviews previews) {
        PlacementStructurePreview structure = new PlacementStructurePreview(parent, previews.createStructure(), previews instanceof LittlePreviews ? previews : null);
        for (LittlePreviews child : previews.getChildren()) {
            structure.addChild(this.createStructureTree(structure, child));
        }
        return structure;
    }

    private void createPreviews(PlacementStructurePreview current, LittleVec inBlockOffset, BlockPos pos) {
        if (current.previews != null) {
            HashMapList splitted = new HashMapList();
            for (PlacePreview pp : current.previews.getPlacePreviews(inBlockOffset)) {
                pp.split(current.previews.getContext(), (HashMapList<BlockPos, PlacePreview>)splitted, pos);
            }
            for (Map.Entry entry : splitted.entrySet()) {
                this.getorCreateBlock((BlockPos)entry.getKey()).addPlacePreviews(current.index, (List)entry.getValue());
            }
        }
        for (PlacementStructurePreview child : current.children) {
            this.createPreviews(child, inBlockOffset, pos);
        }
    }

    public class PlacementStructurePreview {
        public final LittleStructure structure;
        public final LittlePreviews previews;
        public final PlacementStructurePreview parent;
        public final int index;
        List<PlacementStructurePreview> children = new ArrayList<PlacementStructurePreview>();

        public PlacementStructurePreview(PlacementStructurePreview parent, LittleStructure structure, LittlePreviews previews) {
            this.index = Placement.this.structures.size();
            Placement.this.structures.add(this);
            this.parent = parent;
            this.structure = structure;
            this.previews = previews;
        }

        public void addChild(PlacementStructurePreview child) {
            this.children.add(child);
        }
    }

    public class PlacementBlock
    implements IGridBased {
        private final BlockPos pos;
        private TileEntityLittleTiles cached;
        private LittleGridContext context;
        private final List<PlacePreview>[] previews;
        private final List<PlacePreview>[] latePreviews;

        public PlacementBlock(BlockPos pos, LittleGridContext context) {
            this.pos = pos;
            this.context = context;
            this.previews = new List[Placement.this.structures.size()];
            this.latePreviews = new List[Placement.this.structures.size()];
        }

        @Override
        public LittleGridContext getContext() {
            return this.context;
        }

        public void addPlacePreviews(int index, List<PlacePreview> previews) {
            List<PlacePreview> list = this.previews[index];
            if (list == null) {
                this.previews[index] = previews;
            } else {
                list.addAll(previews);
            }
        }

        @Override
        public void convertTo(LittleGridContext to) {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    preview.convertTo(this.context, to);
                }
            }
            this.context = to;
        }

        @Override
        public void convertToSmallest() {
            int size = LittleGridContext.minSize;
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    size = Math.max(size, preview.getSmallestContext(this.context));
                }
            }
            if (size < this.context.size) {
                this.convertTo(LittleGridContext.get(size));
            }
        }

        private boolean needsCollisionTest() {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    if (!preview.needsCollisionTest()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canPlace() {
            if (!this.needsCollisionTest()) {
                return true;
            }
            if (!(Placement.this.ignoreWorldBoundaries || this.pos.func_177956_o() >= 0 && this.pos.func_177956_o() < 256)) {
                return false;
            }
            TileEntityLittleTiles te = LittleAction.loadTe(Placement.this.player, Placement.this.world, this.pos, false);
            if (te != null) {
                LittleGridContext contextBefore = te.getContext();
                te.forceContext(this);
                for (int i = 0; i < this.previews.length; ++i) {
                    if (this.previews[i] == null) continue;
                    for (PlacePreview preview : this.previews[i]) {
                        if (!preview.needsCollisionTest()) continue;
                        if (Placement.this.mode.checkAll()) {
                            if (te.isSpaceForLittleTile(preview.box, Placement.this.predicate)) continue;
                            if (te.getContext() != contextBefore) {
                                te.convertTo(contextBefore);
                            }
                            return false;
                        }
                        if (te.isSpaceForLittleTileStructure(preview.box, Placement.this.predicate)) continue;
                        if (te.getContext() != contextBefore) {
                            te.convertTo(contextBefore);
                        }
                        return false;
                    }
                }
                this.cached = te;
                return true;
            }
            IBlockState state = Placement.this.world.func_180495_p(this.pos);
            if (state.func_185904_a().func_76222_j()) {
                return true;
            }
            return !Placement.this.mode.checkAll() && LittleAction.isBlockValid(state) && LittleAction.canConvertBlock(Placement.this.player, Placement.this.world, this.pos, state);
        }

        public boolean combineTilesSecretly() {
            if (this.cached == null) {
                return false;
            }
            if (this.hasStructure()) {
                for (int i = 0; i < this.previews.length; ++i) {
                    if (this.previews[i] == null || Placement.this.structures.get((int)i).structure == null) continue;
                    this.cached.combineTilesSecretly(Placement.this.structures.get((int)i).structure);
                }
                return false;
            }
            this.cached.combineTilesSecretly();
            return this.cached.size() == 1 && this.cached.convertBlockToVanilla();
        }

        public boolean hasStructure() {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null || Placement.this.structures.get((int)i).structure == null) continue;
                return true;
            }
            return false;
        }

        public void place(PlacementResult result) {
            boolean hascollideBlock = false;
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                Iterator<PlacePreview> iterator = this.previews[i].iterator();
                while (iterator.hasNext()) {
                    PlacePreview preview = iterator.next();
                    if (preview.needsCollisionTest()) {
                        hascollideBlock = true;
                        continue;
                    }
                    if (this.latePreviews[i] == null) {
                        this.latePreviews[i] = new ArrayList<PlacePreview>();
                    }
                    this.latePreviews[i].add(preview);
                    iterator.remove();
                }
            }
            if (hascollideBlock) {
                boolean requiresCollisionTest = true;
                if (this.cached == null) {
                    if (!(Placement.this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockTile) && Placement.this.world.func_180495_p(this.pos).func_185904_a().func_76222_j()) {
                        requiresCollisionTest = false;
                        Placement.this.world.func_175656_a(this.pos, BlockTile.getState(false, false));
                    }
                    this.cached = LittleAction.loadTe(Placement.this.player, Placement.this.world, this.pos, Placement.this.mode.shouldConvertBlock());
                }
                if (this.cached != null) {
                    if (this.cached.isEmpty()) {
                        requiresCollisionTest = false;
                    }
                    boolean collsionTest = requiresCollisionTest;
                    this.cached.forceContext(this);
                    this.cached.updateTilesSecretly(x -> {
                        for (int i = 0; i < this.previews.length; ++i) {
                            if (this.previews[i] == null) continue;
                            PlacementStructurePreview structure = Placement.this.structures.get(i);
                            for (PlacePreview preview : this.previews[i]) {
                                for (LittleTile LT : preview.placeTile(Placement.this.player, this.pos, this.cached.getContext(), this.cached, (TileList)x, Placement.this.unplaceableTiles, Placement.this.removedTiles, Placement.this.mode, Placement.this.facing, collsionTest, structure.structure)) {
                                    if (!Placement.this.soundsToBePlayed.contains(LT.getSound())) {
                                        Placement.this.soundsToBePlayed.add(LT.getSound());
                                    }
                                    if (structure.structure != null) {
                                        if (structure.structure.getMainTile() == null) {
                                            structure.structure.setMainTile(LT);
                                        } else {
                                            LT.connection = structure.structure.getStructureLink(LT);
                                            LT.connection.setLoadedStructure(structure.structure);
                                            structure.structure.add(LT);
                                        }
                                    }
                                    LT.place((TileList)x);
                                    LT.placed(Placement.this.player, Placement.this.facing);
                                    result.addPlacedTile(LT);
                                }
                            }
                        }
                    });
                }
            }
        }

        public void placeLate() {
            for (int i = 0; i < this.latePreviews.length; ++i) {
                if (this.latePreviews[i] == null) continue;
                for (PlacePreview preview : this.latePreviews[i]) {
                    preview.placeTile(Placement.this.player, this.pos, this.context, this.cached, null, Placement.this.unplaceableTiles, Placement.this.removedTiles, Placement.this.mode, Placement.this.facing, false, Placement.this.structures.get((int)i).structure);
                }
            }
        }
    }
}

