/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.ingredient;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.item.ItemBlockIngredient;
import com.creativemd.littletiles.common.item.ItemColorIngredient;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.ColorIngredient;
import com.creativemd.littletiles.common.util.ingredient.IngredientUtils;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredientBase;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.util.ingredient.StackIngredient;
import com.creativemd.littletiles.common.util.ingredient.StackIngredientEntry;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.DyeUtils;

public abstract class LittleIngredient<T extends LittleIngredient>
extends LittleIngredientBase<T> {
    private static HashMap<Class<? extends LittleIngredient>, Integer> typesInv = new HashMap();
    private static List<Class<? extends LittleIngredient>> types = new ArrayList<Class<? extends LittleIngredient>>();
    private static List<IngredientOverflowHandler> overflowHandlers = new ArrayList<IngredientOverflowHandler>();
    private static List<IngredientConvertionHandler> converationHandlers = new ArrayList<IngredientConvertionHandler>();

    public static int indexOf(LittleIngredient ingredient) {
        return LittleIngredient.indexOf(ingredient.getClass());
    }

    public static int indexOf(Class<? extends LittleIngredient> type) {
        return typesInv.get(type);
    }

    public static List<ItemStack> handleOverflow(LittleIngredient ingredient) throws NotEnoughIngredientsException.NotEnoughSpaceException {
        return overflowHandlers.get(LittleIngredient.indexOf(ingredient)).handleOverflow(ingredient);
    }

    public static int typeCount() {
        return types.size();
    }

    static void extract(LittleIngredients ingredients, LittlePreviews previews, boolean onlyStructure) {
        if (!onlyStructure) {
            for (IngredientConvertionHandler handler : converationHandlers) {
                ingredients.add((LittleIngredient)handler.extract(previews));
            }
        }
        if (previews.hasStructure()) {
            previews.getStructureType().addIngredients(previews, ingredients);
        }
        if (previews.hasChildren()) {
            for (LittlePreviews child : previews.getChildren()) {
                LittleIngredient.extract(ingredients, child, onlyStructure);
            }
        }
    }

    public static LittleIngredients extract(LittlePreview preview, double volume) {
        LittleIngredients ingredients = new LittleIngredients();
        for (IngredientConvertionHandler handler : converationHandlers) {
            ingredients.add((LittleIngredient)handler.extract(preview, volume));
        }
        return ingredients;
    }

    public static LittleIngredients extract(LittlePreviews previews) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, previews, false);
        return ingredients;
    }

    public static LittleIngredients extractStructureOnly(LittlePreviews previews) {
        LittleIngredients ingredients = new LittleIngredients();
        LittleIngredient.extract(ingredients, previews, true);
        return ingredients;
    }

    public static LittleIngredients extractWithoutCount(ItemStack stack, boolean useLTStructures) {
        LittleIngredients ingredients = new LittleIngredients();
        ILittleTile tile = PlacementHelper.getLittleInterface(stack);
        if (tile != null) {
            if (useLTStructures && tile.hasLittlePreview(stack) && tile.containsIngredients(stack)) {
                LittleIngredient.extract(ingredients, tile.getLittlePreview(stack), false);
            }
        } else {
            for (IngredientConvertionHandler handler : converationHandlers) {
                ingredients.add((LittleIngredient)handler.extract(stack));
            }
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return ingredients;
    }

    public static boolean handleExtra(LittleIngredient ingredient, ItemStack stack, LittleIngredients overflow) {
        IngredientConvertionHandler handler = converationHandlers.get(LittleIngredient.indexOf(ingredient));
        return handler.requiresExtraHandler() && handler.handleExtra(ingredient, stack, overflow);
    }

    public static <T extends LittleIngredient> void registerType(Class<T> type, IngredientOverflowHandler<T> overflowHandler, IngredientConvertionHandler<T> converationHandler) {
        if (typesInv.containsKey(type)) {
            throw new RuntimeException("Duplicate found! " + types);
        }
        typesInv.put(type, types.size());
        types.add(type);
        overflowHandlers.add(overflowHandler);
        converationHandlers.add(converationHandler);
    }

    @Override
    public abstract T copy();

    public abstract void print(List<String> var1, List<ItemStack> var2);

    @Override
    public abstract T add(T var1);

    @Override
    public abstract T sub(T var1);

    public abstract void scale(int var1);

    public abstract int getMinimumCount(T var1, int var2);

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass();
    }

    public abstract String print(List<Object> var1);

    static {
        LittleIngredient.registerType(BlockIngredient.class, new IngredientOverflowHandler<BlockIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(BlockIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (BlockIngredientEntry entry : overflow) {
                    ItemStack stack;
                    double volume = entry.value;
                    if (volume >= 1.0) {
                        stack = entry.getItemStack();
                        stack.func_190920_e((int)volume);
                        volume -= (double)stack.func_190916_E();
                        stacks.add(stack);
                    }
                    if (!(volume > 0.0)) continue;
                    stack = new ItemStack(LittleTiles.blockIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ItemBlockIngredient.saveIngredient(stack, entry);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<BlockIngredient>(){

            @Override
            public BlockIngredient extract(ItemStack stack) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block != null && !(block instanceof BlockAir) && LittleAction.isBlockValid(BlockUtils.getState((Block)block, (int)stack.func_77960_j()))) {
                    BlockIngredient ingredient = new BlockIngredient();
                    ingredient.add(IngredientUtils.getBlockIngredient(block, stack.func_77960_j(), 1.0));
                    return ingredient;
                }
                return null;
            }

            @Override
            public BlockIngredient extract(LittlePreviews previews) {
                BlockIngredient ingredient = new BlockIngredient();
                if (previews.containsIngredients()) {
                    for (LittlePreview preview : previews) {
                        ingredient.add(preview.getBlockIngredient(previews.getContext()));
                    }
                }
                for (LittlePreviews child : previews.getChildren()) {
                    BlockIngredient childIngredient = this.extract(child);
                    if (childIngredient == null) continue;
                    ingredient.add(childIngredient);
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public BlockIngredient extract(LittlePreview preview, double volume) {
                BlockIngredient ingredient = new BlockIngredient();
                BlockIngredientEntry entry = preview.getBlockIngredient(LittleGridContext.get());
                entry.value = volume;
                ingredient.add(entry);
                return ingredient;
            }
        });
        LittleIngredient.registerType(ColorIngredient.class, new IngredientOverflowHandler<ColorIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(ColorIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ItemStack stack;
                LittleIngredients ingredients = new LittleIngredients(overflow);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                if (overflow.black > 0) {
                    stack = new ItemStack(LittleTiles.blackColorIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ((ItemColorIngredient)stack.func_77973_b()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.cyan > 0) {
                    stack = new ItemStack(LittleTiles.cyanColorIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ((ItemColorIngredient)stack.func_77973_b()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.magenta > 0) {
                    stack = new ItemStack(LittleTiles.magentaColorIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ((ItemColorIngredient)stack.func_77973_b()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                if (overflow.yellow > 0) {
                    stack = new ItemStack(LittleTiles.yellowColorIngredient);
                    stack.func_77982_d(new NBTTagCompound());
                    ((ItemColorIngredient)stack.func_77973_b()).setInventory(stack, ingredients, null);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<ColorIngredient>(){
            Field dyeColor = ReflectionHelper.findField(EnumDyeColor.class, (String[])new String[]{"colorValue", "field_193351_w"});

            @Override
            public ColorIngredient extract(ItemStack stack) {
                if (DyeUtils.isDye((ItemStack)stack)) {
                    Optional optional = DyeUtils.colorFromStack((ItemStack)stack);
                    if (!optional.isPresent()) {
                        return null;
                    }
                    try {
                        ColorIngredient color = ColorIngredient.getColors(this.dyeColor.getInt(optional.get()));
                        color.scale(LittleTiles.CONFIG.survival.dyeVolume);
                        return color;
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            @Override
            public ColorIngredient extract(LittlePreviews previews) {
                ColorIngredient ingredient = new ColorIngredient();
                if (previews.containsIngredients()) {
                    for (LittlePreview preview : previews) {
                        ingredient.add(ColorIngredient.getColors(previews.getContext(), preview));
                    }
                }
                for (LittlePreviews child : previews.getChildren()) {
                    ColorIngredient childIngredient = this.extract(child);
                    if (childIngredient == null) continue;
                    ingredient.add(childIngredient);
                }
                if (ingredient.isEmpty()) {
                    return null;
                }
                return ingredient;
            }

            @Override
            public ColorIngredient extract(LittlePreview preview, double volume) {
                ColorIngredient ingredient = new ColorIngredient();
                ingredient.add(ColorIngredient.getColors(preview, volume));
                return ingredient;
            }
        });
        LittleIngredient.registerType(StackIngredient.class, new IngredientOverflowHandler<StackIngredient>(){

            @Override
            public List<ItemStack> handleOverflow(StackIngredient overflow) throws NotEnoughIngredientsException.NotEnoughSpaceException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (StackIngredientEntry entry : overflow) {
                    ItemStack stack = entry.stack.func_77946_l();
                    stack.func_190920_e(entry.count);
                    stacks.add(stack);
                }
                return stacks;
            }
        }, new IngredientConvertionHandler<StackIngredient>(){

            @Override
            public StackIngredient extract(LittlePreview preview, double volume) {
                return null;
            }

            @Override
            public StackIngredient extract(LittlePreviews previews) {
                return null;
            }

            @Override
            public StackIngredient extract(ItemStack stack) {
                return null;
            }

            @Override
            public boolean requiresExtraHandler() {
                return true;
            }

            @Override
            public boolean handleExtra(StackIngredient ingredient, ItemStack stack, LittleIngredients overflow) {
                StackIngredient stackIngredients = new StackIngredient();
                stackIngredients.add(new StackIngredientEntry(stack, 1));
                int amount = ingredient.getMinimumCount(stackIngredients, stack.func_190916_E());
                if (amount > -1) {
                    stackIngredients.scale(amount);
                    overflow.add(ingredient.sub(stackIngredients));
                    stack.func_190918_g(amount);
                    if (ingredient.isEmpty()) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public static abstract class IngredientConvertionHandler<T extends LittleIngredient> {
        public abstract T extract(ItemStack var1);

        public abstract T extract(LittlePreviews var1);

        public abstract T extract(LittlePreview var1, double var2);

        public boolean requiresExtraHandler() {
            return false;
        }

        public boolean handleExtra(T ingredient, ItemStack stack, LittleIngredients overflow) {
            return false;
        }
    }

    public static abstract class IngredientOverflowHandler<T extends LittleIngredient> {
        public abstract List<ItemStack> handleOverflow(T var1) throws NotEnoughIngredientsException.NotEnoughSpaceException;
    }
}

