/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.place;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PlacePreviewFacing
extends PlacePreview {
    public EnumFacing facing;
    public int color;

    public PlacePreviewFacing(LittleBox box, EnumFacing facing, int color) {
        super(box.copy(), null);
        this.facing = facing;
        this.color = color;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public boolean requiresSplit() {
        return false;
    }

    @Override
    public PlacePreview copy() {
        return new PlacePreviewFacing(this.box.copy(), this.facing, this.color);
    }

    @Override
    public List<LittleRenderingCube> getPreviews(LittleGridContext context) {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        LittleRenderingCube cube = new LittleRenderingCube(this.box.getCube(context), this.box, LittleTiles.coloredBlock, 0);
        cube.setColor(this.color);
        float thickness = 0.03125f;
        EnumFacing.Axis axis = this.facing.func_176740_k();
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + thickness);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - thickness);
        }
        cubes.add(cube);
        return cubes;
    }

    @Override
    public List<LittleTile> placeTile(EntityPlayer player, BlockPos pos, LittleGridContext context, TileEntityLittleTiles teLT, TileList list, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, PlacementMode mode, EnumFacing facing, boolean requiresCollisionTest, LittleStructure structure) {
        return Collections.EMPTY_LIST;
    }
}

