/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleAbsoluteBox
implements IGridBased {
    public BlockPos pos;
    public LittleGridContext context;
    public LittleBox box;

    public LittleAbsoluteBox(BlockPos pos) {
        this.pos = pos;
        this.context = LittleGridContext.getMin();
        this.box = new LittleBox(0, 0, 0, this.context.size, this.context.size, this.context.size);
    }

    public LittleAbsoluteBox(BlockPos pos, LittleBox box, LittleGridContext context) {
        this.pos = pos;
        this.box = box;
        this.context = context;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        this.box.convertTo(this.context, to);
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int size = this.box.getSmallestContext(this.context);
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public LittleVec getDoubledCenter(BlockPos pos) {
        LittleVec vec = this.box.getCenter();
        vec.add(this.pos.func_177973_b((Vec3i)pos), this.context);
        vec.scale(2);
        return vec;
    }

    public LittleVecContext getSize() {
        return new LittleVecContext(this.box.getSize(), this.context);
    }

    public HashMapList<BlockPos, LittleBox> splitted() {
        HashMapList boxes = new HashMapList();
        this.box.split(this.context, this.pos, (HashMapList<BlockPos, LittleBox>)boxes);
        return boxes;
    }

    public int getMinPos(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.pos.func_177958_n() + this.context.toBlockOffset(this.box.minX);
            }
            case Y: {
                return this.pos.func_177956_o() + this.context.toBlockOffset(this.box.minY);
            }
            case Z: {
                return this.pos.func_177952_p() + this.context.toBlockOffset(this.box.minZ);
            }
        }
        return 0;
    }

    public int getMinGridFrom(EnumFacing.Axis axis, BlockPos pos) {
        return this.context.toGrid(RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)) + this.box.getMin(axis);
    }

    public BlockPos getMinPos() {
        int x = this.context.toBlockOffset(this.box.minX);
        int y = this.context.toBlockOffset(this.box.minY);
        int z = this.context.toBlockOffset(this.box.minZ);
        if (x != 0 || y != 0 || z != 0) {
            return this.pos.func_177982_a(x, y, z);
        }
        return this.pos;
    }

    public int getMaxPos(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.pos.func_177958_n() + this.context.toBlockOffset(this.box.maxX);
            }
            case Y: {
                return this.pos.func_177956_o() + this.context.toBlockOffset(this.box.maxY);
            }
            case Z: {
                return this.pos.func_177952_p() + this.context.toBlockOffset(this.box.maxZ);
            }
        }
        return 0;
    }

    public int getMaxGridFrom(EnumFacing.Axis axis, BlockPos pos) {
        return this.context.toGrid(RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)) + this.box.getMax(axis);
    }

    public BlockPos getMaxPos() {
        int x = this.context.toBlockOffset(this.box.maxX);
        int y = this.context.toBlockOffset(this.box.maxY);
        int z = this.context.toBlockOffset(this.box.maxZ);
        if (x != 0 || y != 0 || z != 0) {
            return this.pos.func_177982_a(x, y, z);
        }
        return this.pos;
    }

    public int getDistanceIfEqualFromOneSide(EnumFacing facing, LittleAbsoluteBox box) {
        return this.getDistanceIfEqualFromOneSide(facing, box.box, box.pos, box.context);
    }

    public int getDistanceIfEqualFromOneSide(EnumFacing facing, LittleBox box, BlockPos pos, LittleGridContext context) {
        this.convertToAtMinimum(context);
        if (this.context.size > context.size) {
            box = box.copy();
            box.convertTo(context, this.context);
            context = this.context;
        }
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)axis);
        boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        BlockPos diff = this.pos.func_177973_b((Vec3i)pos);
        int diffOne = context.toGrid(RotationUtils.get((EnumFacing.Axis)one, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)one, (Vec3i)pos));
        int diffTwo = context.toGrid(RotationUtils.get((EnumFacing.Axis)two, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)two, (Vec3i)pos));
        if (box.getMin(one) - diffOne == this.box.getMin(one) && box.getMin(two) - diffTwo == this.box.getMin(two)) {
            return positive ? box.getMin(axis) - context.toGrid(RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)) - this.box.getMax(axis) : this.box.getMin(axis) - (box.getMax(axis) - context.toGrid(RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)this.pos) - RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)));
        }
        return -1;
    }

    public LittleAbsoluteBox createBoxFromFace(EnumFacing facing, int size) {
        LittleAbsoluteBox newBox = new LittleAbsoluteBox(this.pos, this.box.copy(), this.context);
        EnumFacing.Axis axis = facing.func_176740_k();
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            int max = this.box.getMax(axis);
            newBox.box.setMin(axis, max);
            newBox.box.setMax(axis, max + size);
        } else {
            int min = this.box.getMin(axis);
            newBox.box.setMin(axis, min - size);
            newBox.box.setMax(axis, min);
        }
        return newBox;
    }
}

