/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile;

import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.tile.LittleTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleTileColored
extends LittleTile {
    public int color;

    public LittleTileColored(Block block, int meta, Vec3i color) {
        this(block, meta, ColorUtils.RGBToInt((Vec3i)color));
    }

    public LittleTileColored(Block block, int meta, int color) {
        super(block, meta);
        this.color = color;
    }

    public LittleTileColored() {
    }

    @Override
    public void updateTranslucent() {
        super.updateTranslucent();
        if (ColorUtils.isTransparent((int)this.color)) {
            this.cachedTranslucent = (byte)2;
        }
    }

    @Override
    public List<LittleRenderingCube> getInternalRenderingCubes(BlockRenderLayer layer) {
        List<LittleRenderingCube> cubes = super.getInternalRenderingCubes(layer);
        int color = this.color;
        for (int i = 0; i < cubes.size(); ++i) {
            cubes.get((int)i).color = color;
        }
        return cubes;
    }

    @Override
    public void copyExtra(LittleTile tile) {
        super.copyExtra(tile);
        if (tile instanceof LittleTileColored) {
            LittleTileColored thisTile = (LittleTileColored)tile;
            thisTile.color = this.color;
        }
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        super.saveTileExtra(nbt);
        nbt.func_74768_a("color", this.color);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        super.loadTileExtra(nbt);
        this.color = nbt.func_74762_e("color");
    }

    @Override
    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return super.isIdenticalToNBT(nbt) && this.color == nbt.func_74762_e("color");
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (tile instanceof LittleTileColored && super.canBeCombined(tile)) {
            int color1 = ((LittleTileColored)tile).color;
            int color2 = this.color;
            return color1 == color2;
        }
        return false;
    }

    @Override
    public boolean canBeRenderCombined(LittleTile tile) {
        if (tile instanceof LittleTileColored) {
            return super.canBeRenderCombined(tile) && ((LittleTileColored)tile).color == this.color;
        }
        return false;
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }

    @Override
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        if (ColorUtils.isTransparent((int)this.color)) {
            return layer == BlockRenderLayer.TRANSLUCENT;
        }
        return super.shouldBeRenderedInLayer(layer);
    }

    @Override
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        Vec3d result = super.getFogColor(world, pos, state, entity, originalColor, partialTicks);
        Vec3d color = ColorUtils.IntToVec((int)this.color);
        return new Vec3d(result.field_72450_a * color.field_72450_a, result.field_72448_b * color.field_72448_b, result.field_72449_c * color.field_72449_c);
    }

    public static boolean needsToBeRecolored(LittleTile tile, int color) {
        if (ColorUtils.isWhite((int)color) && !ColorUtils.isTransparent((int)color)) {
            return tile.getClass() != LittleTile.class;
        }
        return tile.getClass() != LittleTileColored.class || ((LittleTileColored)tile).color != color;
    }

    public static LittleTile setColor(LittleTile tile, int color) {
        if (ColorUtils.isWhite((int)color) && !ColorUtils.isTransparent((int)color)) {
            return LittleTileColored.removeColor(tile);
        }
        if (tile instanceof LittleTileColored) {
            ((LittleTileColored)tile).color = color;
            if (tile.te.func_145831_w().field_72995_K) {
                tile.updateTranslucent();
            }
        } else {
            LittleTileColored newTile = new LittleTileColored();
            tile.assignTo(newTile);
            newTile.color = color;
            if (tile.te.func_145831_w().field_72995_K) {
                ((LittleTile)newTile).updateTranslucent();
            }
            return newTile;
        }
        return null;
    }

    public static LittleTile removeColor(LittleTile tile) {
        if (tile instanceof LittleTileColored) {
            LittleTile newTile = new LittleTile();
            tile.assignTo(newTile);
            return newTile;
        }
        return null;
    }

    public static int getColor(LittleTile tile) {
        return tile instanceof LittleTileColored ? ((LittleTileColored)tile).color : -1;
    }
}

