/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.ISignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCableBase;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewFacing;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSignalInput
extends LittleSignalCableBase
implements ISignalInput {
    private boolean[] state = new boolean[this.getBandwidth()];
    @StructureDirectional
    public EnumFacing facing;

    public LittleSignalInput(LittleStructureType type) {
        super(type);
    }

    @Override
    public boolean canConnect(EnumFacing facing) {
        return facing == this.facing;
    }

    @Override
    public void setState(boolean[] state) {
        this.state = state;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        nbt.func_74768_a("state", BooleanUtils.boolToInt((boolean[])this.state));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        BooleanUtils.intToBool((int)nbt.func_74762_e("state"), (boolean[])this.state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, int color, List<LittleRenderingCube> cubes) {
        super.renderFace(facing, context, renderBox.copy(), distance, axis, one, two, positive, color, cubes);
        LittleRenderingCube cube = renderBox.getRenderingCube(context, LittleTiles.inputArrow, facing.ordinal());
        cube.keepVU = true;
        cube.allowOverlap = true;
        if (positive) {
            cube.setMin(axis, cube.getMax(axis));
            cube.setMax(axis, cube.getMax(axis) + (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        } else {
            cube.setMax(axis, cube.getMin(axis));
            cube.setMin(axis, cube.getMin(axis) - (float)context.toVanillaGrid(renderBox.getSize(axis)) * 0.7f);
        }
        float shrink = 0.14f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderingCube> cubes, int color) {
        super.render(box, overallBox, cubes, color);
        color = this.getMainTile() instanceof LittleTileColored ? ((LittleTileColored)this.getMainTile()).color : -13619152;
        CubeObject cube = new CubeObject(overallBox.getBox(box.getContext()));
        EnumFacing.Axis axis = this.facing.func_176740_k();
        float sizePercentage = 0.25f;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)axis);
        float sizeOne = cube.getSize(one);
        float sizeTwo = cube.getSize(two);
        float sizeAxis = cube.getSize(axis);
        LittleRenderingCube top = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(color);
        top.allowOverlap = true;
        top.setMin(one, top.getMax(one) - sizeOne * sizePercentage);
        cubes.add(top);
        LittleRenderingCube bottom = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(color);
        bottom.allowOverlap = true;
        bottom.setMax(one, bottom.getMin(one) + sizeOne * sizePercentage);
        cubes.add(bottom);
        LittleRenderingCube left = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(color);
        left.allowOverlap = true;
        left.setMin(two, top.getMax(two) - sizeTwo * sizePercentage);
        cubes.add(left);
        LittleRenderingCube right = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(color);
        right.allowOverlap = true;
        right.setMax(two, right.getMin(two) + sizeTwo * sizePercentage);
        cubes.add(right);
        LittleRenderingCube behind = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(color);
        behind.allowOverlap = true;
        behind.setMin(one, behind.getMin(one) + sizeOne * sizePercentage);
        behind.setMax(one, behind.getMax(one) - sizeOne * sizePercentage);
        behind.setMin(two, behind.getMin(two) + sizeTwo * sizePercentage);
        behind.setMax(two, behind.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            behind.setMax(axis, behind.getMin(axis) + sizeAxis * 0.5f);
        } else {
            behind.setMin(axis, behind.getMax(axis) - sizeAxis * 0.5f);
        }
        cubes.add(behind);
        LittleRenderingCube front = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(-16740609);
        front.allowOverlap = true;
        front.setMin(one, front.getMin(one) + sizeOne * sizePercentage);
        front.setMax(one, front.getMax(one) - sizeOne * sizePercentage);
        front.setMin(two, front.getMin(two) + sizeTwo * sizePercentage);
        front.setMax(two, front.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            front.setMin(axis, front.getMax(axis) - sizeAxis * 0.5f);
            front.setMax(axis, front.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            front.setMax(axis, front.getMin(axis) + sizeAxis * 0.5f);
            front.setMin(axis, front.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(front);
        float thickness = 1.0E-4f;
        LittleRenderingCube frontTop = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(-16740609);
        frontTop.allowOverlap = true;
        frontTop.setMin(one, frontTop.getMin(one) + sizeOne * sizePercentage);
        frontTop.setMax(one, frontTop.getMin(one) + thickness);
        frontTop.setMin(two, frontTop.getMin(two) + sizeTwo * sizePercentage);
        frontTop.setMax(two, frontTop.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontTop.setMin(axis, frontTop.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontTop.setMax(axis, frontTop.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontTop);
        LittleRenderingCube frontBottom = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(-16740609);
        frontBottom.allowOverlap = true;
        frontBottom.setMax(one, frontBottom.getMax(one) - sizeOne * sizePercentage);
        frontBottom.setMin(one, frontBottom.getMax(one) - thickness);
        frontBottom.setMin(two, frontBottom.getMin(two) + sizeTwo * sizePercentage);
        frontBottom.setMax(two, frontBottom.getMax(two) - sizeTwo * sizePercentage);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontBottom.setMin(axis, frontBottom.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontBottom.setMax(axis, frontBottom.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontBottom);
        LittleRenderingCube frontRight = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(-16740609);
        frontRight.allowOverlap = true;
        frontRight.setMin(one, frontRight.getMin(one) + sizeOne * sizePercentage);
        frontRight.setMax(one, frontRight.getMax(one) - sizeOne * sizePercentage);
        frontRight.setMin(two, frontRight.getMin(two) + sizeTwo * sizePercentage);
        frontRight.setMax(two, frontRight.getMin(two) + thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontRight.setMin(axis, frontRight.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontRight.setMax(axis, frontRight.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontRight);
        LittleRenderingCube frontLeft = (LittleRenderingCube)new LittleRenderingCube(cube, null, LittleTiles.coloredBlock, 0).setColor(-16740609);
        frontLeft.allowOverlap = true;
        frontLeft.setMin(one, frontLeft.getMin(one) + sizeOne * sizePercentage);
        frontLeft.setMax(one, frontLeft.getMax(one) - sizeOne * sizePercentage);
        frontLeft.setMax(two, frontLeft.getMax(two) - sizeTwo * sizePercentage);
        frontLeft.setMin(two, frontLeft.getMax(two) - thickness);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            frontLeft.setMin(axis, frontLeft.getMax(axis) - sizeAxis * sizePercentage);
        } else {
            frontLeft.setMax(axis, frontLeft.getMin(axis) + sizeAxis * sizePercentage);
        }
        cubes.add(frontLeft);
    }

    @Override
    public int getIndex(EnumFacing facing) {
        return 0;
    }

    @Override
    public EnumFacing getFacing(int index) {
        return this.facing;
    }

    public static class LittleStructureTypeInput
    extends LittleSignalCableBase.LittleStructureTypeNetwork {
        @SideOnly(value=Side.CLIENT)
        public List<RenderCubeObject> cubes;

        public LittleStructureTypeInput(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth) {
            super(id, category, structureClass, attribute, modid, bandwidth, 1);
        }

        @Override
        public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
            List<PlacePreview> result = super.getSpecialTiles(previews);
            EnumFacing facing = (EnumFacing)this.loadDirectional(previews, "facing");
            LittleBox box = previews.getSurroundingBox();
            result.add(new PlacePreviewFacing(box, facing, -16740609));
            return result;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<RenderCubeObject> getRenderingCubes(LittlePreviews previews) {
            if (this.cubes == null) {
                float size = (float)(Math.sqrt(this.bandwidth) * 1.0 / 32.0 * 1.4);
                this.cubes = new ArrayList<RenderCubeObject>();
                this.cubes.add(new RenderCubeObject(0.0f, 0.5f - size, 0.5f - size, size * 2.0f, 0.5f + size, 0.5f + size, LittleTiles.coloredBlock).setColor(-13619152));
            }
            return this.cubes;
        }
    }
}

