/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.ISignalBase;
import com.creativemd.littletiles.common.structure.signal.SignalNetwork;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleSignalCableBase
extends LittleStructurePremade
implements ISignalBase {
    private SignalNetwork network;
    protected LittleConnectionFace[] faces = new LittleConnectionFace[this.getNumberOfConnections()];

    public LittleSignalCableBase(LittleStructureType type) {
        super(type);
    }

    @Override
    public SignalNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SignalNetwork network) {
        this.network = network;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        int[] result = nbt.func_74759_k("faces");
        if (result != null && result.length == this.getNumberOfConnections() * 2) {
            for (int i = 0; i < this.faces.length; ++i) {
                int distance = result[i * 2];
                if (distance < 0) {
                    this.faces[i] = null;
                    continue;
                }
                this.faces[i] = new LittleConnectionFace();
                this.faces[i].distance = distance;
                this.faces[i].context = LittleGridContext.get(result[i * 2 + 1]);
            }
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        int[] result = new int[this.getNumberOfConnections() * 2];
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] != null) {
                result[i * 2] = this.faces[i].distance;
                result[i * 2 + 1] = this.faces[i].context.size;
                continue;
            }
            result[i * 2] = -1;
            result[i * 2 + 1] = 0;
        }
        nbt.func_74783_a("faces", result);
    }

    public abstract EnumFacing getFacing(int var1);

    public abstract int getIndex(EnumFacing var1);

    @Override
    public int getBandwidth() {
        return ((LittleStructureTypeNetwork)this.type).bandwidth;
    }

    public int getNumberOfConnections() {
        return ((LittleStructureTypeNetwork)this.type).numberOfConnections;
    }

    @Override
    public void connect(EnumFacing facing, ISignalBase base, LittleGridContext context, int distance) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            if (this.faces[index].getConnection() == base) {
                return;
            }
            this.faces[index].disconnect(facing);
        } else {
            this.faces[index] = new LittleConnectionFace();
        }
        this.faces[index].connect(base, context, distance);
    }

    @Override
    public void disconnect(EnumFacing facing, ISignalBase base) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            this.faces[index] = null;
            this.updateStructure();
        }
    }

    @Override
    public void neighbourChanged() {
        if (this.getWorld().field_72995_K || !this.load()) {
            return;
        }
        LittleAbsoluteBox box = new SurroundingBox(false).add(this.tiles.entrySet()).getAbsoluteBox();
        for (int i = 0; i < this.faces.length; ++i) {
            EnumFacing facing = this.getFacing(i);
            LittleConnectResult result = this.checkConnection(facing, box);
            if (result != null) {
                this.connect(facing, result.base, result.context, result.distance);
                result.base.connect(facing.func_176734_d(), this, result.context, result.distance);
                continue;
            }
            if (this.faces[i] != null) {
                this.faces[i].disconnect(facing);
            }
            this.faces[i] = null;
        }
    }

    @Override
    public Iterator<ISignalBase> connections() {
        if (this.load()) {
            return new Iterator<ISignalBase>(){
                int index = this.searchForNextIndex(0);
                LittleAbsoluteBox box = new SurroundingBox(false).add(LittleSignalCableBase.access$000(LittleSignalCableBase.this).entrySet()).getAbsoluteBox();

                int searchForNextIndex(int index) {
                    while (!(index >= LittleSignalCableBase.this.faces.length || LittleSignalCableBase.this.faces[index] != null && LittleSignalCableBase.this.faces[index].verifyConnect(LittleSignalCableBase.this.getFacing(index), this.box))) {
                        LittleSignalCableBase.this.faces[index] = null;
                        ++index;
                    }
                    return index;
                }

                @Override
                public boolean hasNext() {
                    return this.index < LittleSignalCableBase.this.faces.length && LittleSignalCableBase.this.faces[this.index] != null;
                }

                @Override
                public ISignalBase next() {
                    ISignalBase next = LittleSignalCableBase.this.faces[this.index].getConnection();
                    this.index = this.searchForNextIndex(this.index++);
                    return next;
                }
            };
        }
        return new Iterator<ISignalBase>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public ISignalBase next() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LittleConnectResult checkConnection(World world, LittleAbsoluteBox box, EnumFacing facing, BlockPos pos) throws ConnectionException {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
            LittleTile closest = null;
            int minDistance = 0;
            for (Object tile : te) {
                int distance;
                if (((LittleTile)tile).isChildOfStructure(this) || (distance = box.getDistanceIfEqualFromOneSide(facing, ((LittleTile)tile).box, ((LittleTile)tile).te.func_174877_v(), ((LittleTile)tile).getContext())) < 0 || closest != null && minDistance <= distance) continue;
                closest = tile;
                minDistance = distance;
            }
            if (closest != null && closest.isChildOfStructure() && closest.connection.getStructure(world) instanceof ISignalBase && ((ISignalBase)((Object)closest.connection.getStructureWithoutLoading())).compatible(this)) {
                box = box.createBoxFromFace(facing, minDistance);
                HashMapList<BlockPos, LittleBox> boxes = box.splitted();
                for (Map.Entry entry : boxes.entrySet()) {
                    TileEntity toSearchIn = world.func_175625_s((BlockPos)entry.getKey());
                    if (toSearchIn instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles parsedSearch = (TileEntityLittleTiles)toSearchIn;
                        LittleBox toCheck = (LittleBox)((ArrayList)entry.getValue()).get(0);
                        try {
                            parsedSearch.convertToAtMinimum(box.getContext());
                            if (parsedSearch.getContext().size > box.getContext().size) {
                                toCheck.convertTo(box.getContext(), parsedSearch.getContext());
                            }
                            if (parsedSearch.isSpaceForLittleTile(toCheck)) continue;
                            throw new ConnectionException("No space");
                        }
                        finally {
                            parsedSearch.convertToSmallest();
                            continue;
                        }
                    }
                    if (world.func_180495_p((BlockPos)entry.getKey()).func_185904_a().func_76222_j()) continue;
                    throw new ConnectionException("Block in the way");
                }
                ISignalBase base = (ISignalBase)((Object)closest.connection.getStructureWithoutLoading());
                if (base.canConnect(facing.func_176734_d())) {
                    return new LittleConnectResult(base, box.getContext(), minDistance);
                }
                throw new ConnectionException("Side is invalid");
            }
            if (closest != null) {
                throw new ConnectionException("Tile in the way");
            }
        }
        return null;
    }

    public LittleConnectResult checkConnection(EnumFacing facing, LittleAbsoluteBox box) {
        boolean positive;
        if (!this.canConnect(facing)) {
            return null;
        }
        BlockPos pos = box.getMinPos();
        EnumFacing.Axis axis = facing.func_176740_k();
        boolean bl = positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        if (positive) {
            pos = RotationUtils.setValue((BlockPos)pos, (int)box.getMaxPos(axis), (EnumFacing.Axis)axis);
        }
        World world = this.getWorld();
        try {
            LittleConnectResult result;
            if ((positive ? box.getMaxGridFrom(axis, pos) < box.getContext().size : box.getMinGridFrom(axis, pos) > 0) && (result = this.checkConnection(world, box, facing, pos)) != null) {
                return result;
            }
            return this.checkConnection(world, box, facing, pos.func_177972_a(facing));
        }
        catch (ConnectionException e) {
            return null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getRenderingCubes(BlockPos pos, BlockRenderLayer layer, List<LittleRenderingCube> cubes) {
        if (layer != BlockRenderLayer.SOLID) {
            return;
        }
        int color = this.getMainTile() instanceof LittleTileColored ? ((LittleTileColored)this.getMainTile()).color : -1;
        SurroundingBox box = new SurroundingBox(false).add(this.tiles.entrySet());
        LittleVec min = box.getMinPosOffset();
        LittleVec max = box.getSize();
        max.add(min);
        LittleBox overallBox = new LittleBox(min, max);
        BlockPos difference = pos.func_177973_b((Vec3i)box.getMinPos());
        overallBox.sub(box.getContext().toGrid(difference.func_177958_n()), box.getContext().toGrid(difference.func_177956_o()), box.getContext().toGrid(difference.func_177952_p()));
        this.render(box, overallBox, cubes, color);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, int color, List<LittleRenderingCube> cubes) {
        if (positive) {
            renderBox.setMin(axis, renderBox.getMax(axis));
            renderBox.setMax(axis, renderBox.getMax(axis) + distance);
        } else {
            renderBox.setMax(axis, renderBox.getMin(axis));
            renderBox.setMin(axis, renderBox.getMin(axis) - distance);
        }
        LittleRenderingCube cube = renderBox.getRenderingCube(context, LittleTiles.singleCable, axis.ordinal());
        if (positive) {
            cube.setMax(axis, cube.getMin(axis) + cube.getSize(axis) / 2.0f);
        } else {
            cube.setMin(axis, cube.getMax(axis) - cube.getSize(axis) / 2.0f);
        }
        cube.color = color;
        cube.keepVU = true;
        cube.allowOverlap = true;
        float shrink = 0.18f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderingCube> cubes, int color) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.renderFace(facing, context, renderBox, distance, axis, one, two, positive, color, cubes);
        }
    }

    static /* synthetic */ HashMapList access$000(LittleSignalCableBase x0) {
        return x0.tiles;
    }

    public static abstract class LittleStructureTypeNetwork
    extends LittleStructurePremade.LittleStructureTypePremade {
        public final int bandwidth;
        public final int numberOfConnections;

        public LittleStructureTypeNetwork(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth, int numberOfConnections) {
            super(id, category, structureClass, attribute | 0x10000, modid);
            this.bandwidth = bandwidth;
            this.numberOfConnections = numberOfConnections;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<LittleRenderingCube> getPositingCubes(World world, BlockPos pos, ItemStack stack) {
            ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
            for (int i = 0; i < 6; ++i) {
                EnumFacing facing = EnumFacing.field_82609_l[i];
                EnumFacing.Axis axis = facing.func_176740_k();
                TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
                if (!(tileEntity instanceof TileEntityLittleTiles)) continue;
                for (LittleStructure structure : ((TileEntityLittleTiles)tileEntity).allStructures()) {
                    if (!(structure instanceof ISignalBase) || ((ISignalBase)((Object)structure)).getBandwidth() != this.bandwidth || !((ISignalBase)((Object)structure)).canConnect(facing.func_176734_d())) continue;
                    LittleRenderingCube cube = new LittleRenderingCube(new CubeObject(structure.getSurroundingBox().func_72317_d((double)(-tileEntity.func_174877_v().func_177958_n()), (double)(-tileEntity.func_174877_v().func_177956_o()), (double)(-tileEntity.func_174877_v().func_177952_p()))), null, Blocks.field_150350_a, 0);
                    cube.setMin(axis, 0.0f);
                    cube.setMax(axis, 1.0f);
                    cubes.add(cube);
                }
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityLittleTiles) {
                for (LittleStructure structure : ((TileEntityLittleTiles)tileEntity).allStructures()) {
                    LittleRenderingCube cube;
                    if (!(structure instanceof ISignalBase) || ((ISignalBase)((Object)structure)).getBandwidth() != this.bandwidth) continue;
                    AxisAlignedBB box = structure.getSurroundingBox().func_72317_d((double)(-tileEntity.func_174877_v().func_177958_n()), (double)(-tileEntity.func_174877_v().func_177956_o()), (double)(-tileEntity.func_174877_v().func_177952_p()));
                    if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.WEST) || ((ISignalBase)((Object)structure)).canConnect(EnumFacing.EAST)) {
                        cube = new LittleRenderingCube(new CubeObject(box), null, Blocks.field_150350_a, 0);
                        if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.WEST)) {
                            cube.setMin(EnumFacing.Axis.X, 0.0f);
                        }
                        if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.EAST)) {
                            cube.setMax(EnumFacing.Axis.X, 1.0f);
                        }
                        cubes.add(cube);
                    }
                    if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.DOWN) || ((ISignalBase)((Object)structure)).canConnect(EnumFacing.UP)) {
                        cube = new LittleRenderingCube(new CubeObject(box), null, Blocks.field_150350_a, 0);
                        if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.DOWN)) {
                            cube.setMin(EnumFacing.Axis.Y, 0.0f);
                        }
                        if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.UP)) {
                            cube.setMax(EnumFacing.Axis.Y, 1.0f);
                        }
                        cubes.add(cube);
                    }
                    if (!((ISignalBase)((Object)structure)).canConnect(EnumFacing.NORTH) && !((ISignalBase)((Object)structure)).canConnect(EnumFacing.SOUTH)) continue;
                    cube = new LittleRenderingCube(new CubeObject(box), null, Blocks.field_150350_a, 0);
                    if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.NORTH)) {
                        cube.setMin(EnumFacing.Axis.Z, 0.0f);
                    }
                    if (((ISignalBase)((Object)structure)).canConnect(EnumFacing.SOUTH)) {
                        cube.setMax(EnumFacing.Axis.Z, 1.0f);
                    }
                    cubes.add(cube);
                }
            }
            if (cubes.isEmpty()) {
                return null;
            }
            return cubes;
        }
    }

    public static class ConnectionException
    extends Exception {
        public ConnectionException(String msg) {
            super(msg);
        }
    }

    public static class LittleConnectResult {
        public final ISignalBase base;
        public final LittleGridContext context;
        public final int distance;

        public LittleConnectResult(ISignalBase base, LittleGridContext context, int distance) {
            this.base = base;
            this.context = context;
            this.distance = distance;
        }
    }

    public class LittleConnectionFace {
        public ISignalBase connection;
        public int distance;
        public LittleGridContext context;

        public void disconnect(EnumFacing facing) {
            if (this.connection != null) {
                this.connection.disconnect(facing.func_176734_d(), LittleSignalCableBase.this);
            }
            if (LittleSignalCableBase.this.hasNetwork()) {
                LittleSignalCableBase.this.getNetwork().remove(this.connection);
            }
            this.connection = null;
            LittleSignalCableBase.this.updateStructure();
        }

        public void connect(ISignalBase connection, LittleGridContext context, int distance) {
            if (this.connection != null) {
                throw new RuntimeException("Cannot connect until old connection is closed");
            }
            if (LittleSignalCableBase.this.hasNetwork()) {
                LittleSignalCableBase.this.getNetwork().add(connection);
            }
            this.connection = connection;
            this.context = context;
            this.distance = distance;
            LittleSignalCableBase.this.updateStructure();
        }

        public boolean verifyConnect(EnumFacing facing, LittleAbsoluteBox box) {
            if (this.connection != null) {
                return true;
            }
            LittleConnectResult result = LittleSignalCableBase.this.checkConnection(facing, box);
            if (result != null) {
                this.connection = result.base;
                this.context = result.context;
                this.distance = result.distance;
                return true;
            }
            return false;
        }

        public ISignalBase getConnection() {
            return this.connection;
        }
    }
}

