/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.item.ItemPremadeStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleExporter;
import com.creativemd.littletiles.common.structure.type.premade.LittleImporter;
import com.creativemd.littletiles.common.structure.type.premade.LittleWorkbench;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalCable;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalInput;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.google.common.base.Charsets;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public abstract class LittleStructurePremade
extends LittleStructure {
    private static LinkedHashMap<String, LittleStructurePremadeEntry> structurePreviews = new LinkedHashMap();
    private static List<LittleStructureTypePremade> premadeStructures = new ArrayList<LittleStructureTypePremade>();
    private static JsonParser parser = new JsonParser();

    public LittleStructurePremade(LittleStructureType type) {
        super(type);
    }

    public static void reloadPremadeStructures() {
        structurePreviews.clear();
        ItemPremadeStructure.clearCache();
        for (LittleStructureTypePremade type : premadeStructures) {
            try {
                ItemStack stack = new ItemStack(LittleTiles.premade);
                NBTTagCompound structureNBT = new NBTTagCompound();
                structureNBT.func_74778_a("id", type.id);
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream("assets/" + type.modid + "/premade/" + type.id + ".struct"), (Charset)Charsets.UTF_8));
                nbt.func_74782_a("structure", (NBTBase)structureNBT);
                stack.func_77982_d(nbt);
                LittlePreviews previews = LittlePreview.getPreview(stack);
                NBTTagCompound stackNBT = new NBTTagCompound();
                stackNBT.func_74782_a("structure", (NBTBase)structureNBT);
                stack.func_77982_d(stackNBT);
                structurePreviews.put(type.id, new LittleStructurePremadeEntry(previews, stack));
                System.out.println("Loaded " + type.id + " model");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not load '" + type.id + "'! Structure will not be registered");
            }
        }
    }

    public static void registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure) {
        LittleStructurePremade.registerPremadeStructureType(id, modid, classStructure, 0);
    }

    public static void registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure, int attribute) {
        premadeStructures.add((LittleStructureTypePremade)LittleStructureRegistry.registerStructureType(new LittleStructureTypePremade(id, "premade", classStructure, attribute, modid), null));
    }

    public static void registerPremadeStructureType(LittleStructureTypePremade type) {
        premadeStructures.add((LittleStructureTypePremade)LittleStructureRegistry.registerStructureType(type, null));
    }

    public static LittlePreviews getPreviews(String id) {
        return LittleStructurePremade.getStructurePremadeEntry((String)id).previews;
    }

    public static LittleStructurePremadeEntry getStructurePremadeEntry(String id) {
        return structurePreviews.get(id);
    }

    public static Collection<LittleStructurePremadeEntry> getPremadeStructures() {
        return structurePreviews.values();
    }

    public static List<LittleStructureTypePremade> getPremadeStructureTypes() {
        return premadeStructures;
    }

    public static Set<String> getPremadeStructureIds() {
        return structurePreviews.keySet();
    }

    public static ItemStack tryGetPremadeStack(String id) {
        LittleStructurePremadeEntry entry = structurePreviews.get(id);
        if (entry != null) {
            return entry.stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPremadeStack(String id) {
        return LittleStructurePremade.structurePreviews.get((Object)id).stack.func_77946_l();
    }

    @Override
    public ItemStack getStructureDrop() {
        return LittleStructurePremade.getPremadeStack(this.type.id).func_77946_l();
    }

    public static void initPremadeStructures() {
        LittleStructurePremade.registerPremadeStructureType("workbench", "littletiles", LittleWorkbench.class);
        LittleStructurePremade.registerPremadeStructureType("importer", "littletiles", LittleImporter.class);
        LittleStructurePremade.registerPremadeStructureType("exporter", "littletiles", LittleExporter.class);
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable1", "premade", LittleSignalCable.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable4", "premade", LittleSignalCable.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalCable.LittleStructureTypeCable("single_cable16", "premade", LittleSignalCable.class, 512, "littletiles", 16));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output1", "premade", LittleSignalOutput.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output4", "premade", LittleSignalOutput.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalOutput.LittleStructureTypeOutput("single_output16", "premade", LittleSignalOutput.class, 512, "littletiles", 16));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input1", "premade", LittleSignalInput.class, 512, "littletiles", 1));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input4", "premade", LittleSignalInput.class, 512, "littletiles", 4));
        LittleStructurePremade.registerPremadeStructureType(new LittleSignalInput.LittleStructureTypeInput("single_input16", "premade", LittleSignalInput.class, 512, "littletiles", 16));
    }

    public static class LittleStructurePremadeEntry {
        public final LittlePreviews previews;
        public final ItemStack stack;

        public LittleStructurePremadeEntry(LittlePreviews previews, ItemStack stack) {
            this.previews = previews;
            this.stack = stack;
        }

        public boolean arePreviewsEqual(LittlePreviews previews) {
            return this.previews.isVolumeEqual(previews);
        }
    }

    public static class LittleStructureTypePremade
    extends LittleStructureType {
        public final String modid;

        public LittleStructureTypePremade(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid) {
            super(id, category, structureClass, 4 | attribute);
            this.modid = modid;
        }

        public ItemStack createItemStack() {
            ItemStack stack = new ItemStack(LittleTiles.premade);
            NBTTagCompound structureNBT = new NBTTagCompound();
            structureNBT.func_74778_a("id", this.id);
            NBTTagCompound stackNBT = new NBTTagCompound();
            stackNBT.func_74782_a("structure", (NBTBase)structureNBT);
            stack.func_77982_d(stackNBT);
            return stack;
        }

        @SideOnly(value=Side.CLIENT)
        public List<RenderCubeObject> getRenderingCubes(LittlePreviews previews) {
            return null;
        }

        @Override
        public boolean canOnlyBePlacedByItemStack() {
            return true;
        }
    }
}

