/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDoorEvents;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDoorSettings;
import com.creativemd.littletiles.client.render.world.LittleRenderChunkSuppilier;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import com.creativemd.littletiles.common.structure.animation.AnimationTimeline;
import com.creativemd.littletiles.common.structure.animation.ValueTimeline;
import com.creativemd.littletiles.common.structure.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.structure.animation.event.ChildActivateEvent;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.exception.MissingTileEntity;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleAxisDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorActivator;
import com.creativemd.littletiles.common.structure.type.door.LittleSlidingDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleDoorBase
extends LittleDoor
implements IAnimatedStructure {
    public int interpolation = 0;
    public int duration = 50;
    public boolean stayAnimated = false;
    public boolean noClip = false;
    public List<AnimationEvent> events = new ArrayList<AnimationEvent>();
    public EntityAnimation animation;

    public LittleDoorBase(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.events = new ArrayList<AnimationEvent>();
        NBTTagList list = nbt.func_150295_c("events", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            AnimationEvent event = AnimationEvent.loadFromNBT(list.func_150305_b(i));
            if (event == null) continue;
            this.events.add(event);
        }
        this.duration = nbt.func_74764_b("duration") ? nbt.func_74762_e("duration") : 50;
        this.stayAnimated = nbt.func_74767_n("stayAnimated");
        this.interpolation = nbt.func_74762_e("interpolation");
        this.noClip = nbt.func_74767_n("noClip");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        NBTTagList list = new NBTTagList();
        for (AnimationEvent event : this.events) {
            list.func_74742_a((NBTBase)event.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("events", (NBTBase)list);
        nbt.func_74768_a("duration", this.duration);
        if (this.stayAnimated) {
            nbt.func_74757_a("stayAnimated", this.stayAnimated);
        }
        nbt.func_74768_a("interpolation", this.interpolation);
        if (this.noClip) {
            nbt.func_74757_a("noClip", this.noClip);
        } else {
            nbt.func_82580_o("noClip");
        }
    }

    public abstract LittleTransformation[] getDoorTransformations(@Nullable EntityPlayer var1);

    public abstract void transformDoorPreview(LittleAbsolutePreviews var1, LittleTransformation var2);

    public LittleAbsolutePreviews getDoorPreviews(LittleTransformation transformation) {
        LittleAbsolutePreviews previews = this.getAbsolutePreviewsSameWorldOnly(transformation.center);
        this.transformDoorPreview(previews, transformation);
        transformation.transform(previews);
        return previews;
    }

    @Override
    public void startAnimation(EntityAnimation animation) {
        for (int i = 0; i < this.events.size(); ++i) {
            this.events.get(i).reset();
        }
    }

    @Override
    public void beforeTick(EntityAnimation animation, int tick) {
        super.beforeTick(animation, tick);
        DoorController controller = (DoorController)animation.controller;
        for (AnimationEvent event : this.events) {
            if (!event.shouldBeProcessed(tick)) continue;
            event.process(controller);
        }
    }

    @Override
    public void finishAnimation(EntityAnimation animation) {
        int duration = this.getCompleteDuration();
        for (AnimationEvent event : this.events) {
            event.invert(this, duration);
        }
        this.events.sort(null);
    }

    @Override
    public int getCompleteDuration() {
        int duration = this.duration;
        for (AnimationEvent event : this.events) {
            duration = Math.max(duration, event.getMinimumRequiredDuration(this));
        }
        return duration;
    }

    @Override
    public List<LittleDoor> collectDoorsToCheck() {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (AnimationEvent event : this.events) {
            if (!(event instanceof ChildActivateEvent) || children.contains(((ChildActivateEvent)event).childId)) continue;
            children.add(((ChildActivateEvent)event).childId);
        }
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        if (children.isEmpty()) {
            return doors;
        }
        for (Integer integer : children) {
            if (this.children.size() <= integer || !(this.children.get(integer) instanceof LittleDoor)) continue;
            doors.add((LittleDoor)((IStructureChildConnector)this.children.get(integer)).getStructure(this.getWorld()));
        }
        return doors;
    }

    @Override
    public LittleDoor.DoorOpeningResult canOpenDoor(@Nullable EntityPlayer player) {
        LittleTransformation[] transformations;
        LittleDoor.DoorOpeningResult result = super.canOpenDoor(player);
        if (result == null) {
            return null;
        }
        for (AnimationEvent event : this.events) {
            event.reset();
        }
        if (this.isAnimated()) {
            return result;
        }
        for (LittleTransformation transformation : transformations = this.getDoorTransformations(player)) {
            ArrayList placePreviews = new ArrayList();
            LittleAbsolutePreviews previews = this.getDoorPreviews(transformation);
            Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(this.getWorld(), previews, previews.pos, PlacementMode.all)).setPredicate(x -> !x.isChildOfStructure(this));
            if (!placement.canPlace()) continue;
            if (transformations.length == 1) {
                return result;
            }
            if (result.isEmpty()) {
                result = new LittleDoor.DoorOpeningResult(new NBTTagCompound());
            }
            result.nbt.func_74783_a("transform", transformation.array());
            return result;
        }
        return null;
    }

    public EntityAnimation place(World world, SubWorld fakeWorld, @Nullable EntityPlayer player, Placement placement, DoorController controller, UUID uuid, StructureAbsolute absolute, LittleTransformation transformation, boolean tickOnce) {
        controller.noClip = this.noClip;
        ArrayList blocks = new ArrayList();
        fakeWorld.preventNeighborUpdate = true;
        PlacementResult result = placement.tryPlace();
        if (result == null) {
            throw new RuntimeException("Something went wrong during placing the door!");
        }
        controller.activator = player;
        if (world.field_72995_K) {
            controller.markWaitingForApprove();
        }
        fakeWorld.preventNeighborUpdate = false;
        LittleDoorBase newDoor = (LittleDoorBase)result.parentStructure;
        EntityAnimation animation = new EntityAnimation(world, (CreativeWorld)fakeWorld, controller, placement.pos, uuid, absolute, newDoor.getAbsoluteIdentifier());
        newDoor.transferChildrenToAnimation(animation);
        newDoor.transformAnimation(transformation);
        if (this.parent != null) {
            LittleStructure parentStructure = this.parent.getStructure(world);
            parentStructure.updateChildConnection(this.parent.getChildID(), newDoor);
            newDoor.updateParentConnection(this.parent.getChildID(), parentStructure);
        }
        animation.controller.startTransition("opened");
        world.func_72838_d((Entity)animation);
        if (tickOnce) {
            animation.onUpdateForReal();
        }
        return animation;
    }

    @Override
    public boolean canOpenDoor(@Nullable EntityPlayer player, LittleDoor.DoorOpeningResult result) {
        if (!super.canOpenDoor(player, result)) {
            return false;
        }
        LittleTransformation transform = !result.isEmpty() && result.nbt.func_74764_b("transform") ? new LittleTransformation(result.nbt.func_74759_k("transform")) : this.getDoorTransformations(player)[0];
        ArrayList placePreviews = new ArrayList();
        LittleAbsolutePreviews previews = this.getDoorPreviews(transform);
        Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews(this.getWorld(), previews, previews.pos, PlacementMode.all)).setPredicate(x -> !x.isChildOfStructure(this));
        return placement.canPlace();
    }

    @Override
    public EntityAnimation openDoor(@Nullable EntityPlayer player, UUIDSupplier uuid, LittleDoor.DoorOpeningResult result, boolean tickOnce) {
        if (this.isAnimated()) {
            ((DoorController)this.animation.controller).activate();
            if (tickOnce) {
                this.animation.onUpdateForReal();
            }
            return this.animation;
        }
        LittleTransformation transform = !result.isEmpty() && result.nbt.func_74764_b("transform") ? new LittleTransformation(result.nbt.func_74759_k("transform")) : this.getDoorTransformations(player)[0];
        LittleAbsolutePreviews previews = this.getDoorPreviews(transform);
        World world = this.getWorld();
        SubWorld fakeWorld = SubWorld.createFakeWorld((World)world);
        if (world.field_72995_K) {
            fakeWorld.renderChunkSupplier = new LittleRenderChunkSuppilier();
        }
        Placement placement = new Placement(player, PlacementHelper.getAbsolutePreviews((World)fakeWorld, previews, previews.pos, PlacementMode.all));
        StructureAbsolute absolute = this.getAbsoluteAxis();
        HashMapList<BlockPos, LittleTile> allTilesFromWorld = this.collectBlockTilesChildren((HashMapList<BlockPos, LittleTile>)new HashMapList(), true);
        EntityAnimation animation = this.place(this.getWorld(), fakeWorld, player, placement, this.createController(result, uuid, placement, transform, this.getCompleteDuration()), uuid.next(), absolute, transform, tickOnce);
        boolean sendUpdate = !world.field_72995_K && world instanceof WorldServer;
        for (Map.Entry entry : allTilesFromWorld.entrySet()) {
            try {
                TileEntityLittleTiles te = this.loadTE((BlockPos)entry.getKey());
                te.updateTiles(x -> x.removeAll((Collection)entry.getValue()));
                if (!sendUpdate) continue;
                ((WorldServer)world).func_184164_w().func_180244_a(te.func_174877_v());
            }
            catch (MissingTileEntity e) {
                e.printStackTrace();
            }
        }
        return animation;
    }

    public abstract DoorController createController(LittleDoor.DoorOpeningResult var1, UUIDSupplier var2, Placement var3, LittleTransformation var4, int var5);

    public abstract StructureAbsolute getAbsoluteAxis();

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public boolean isInMotion() {
        return this.animation != null && this.animation.controller.isChanging();
    }

    @Override
    public boolean isAnimated() {
        return this.animation != null;
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void destroyAnimation() {
        this.animation.markRemoved();
    }

    public static void initDoors() {
        LittleStructureRegistry.registerStructureType(new LittleAxisDoor.LittleAxisDoorType("door", "door", LittleAxisDoor.class, 0), LittleAxisDoor.LittleAxisDoorParser.class);
        LittleStructureRegistry.registerStructureType(new LittleDoor.LittleDoorType("slidingDoor", "door", LittleSlidingDoor.class, 0), LittleSlidingDoor.LittleSlidingDoorParser.class);
        LittleStructureRegistry.registerStructureType(new LittleAdvancedDoor.LittleAdvancedDoorType("advancedDoor", "door", LittleAdvancedDoor.class, 0), LittleAdvancedDoor.LittleAdvancedDoorParser.class);
        LittleStructureRegistry.registerStructureType(new LittleDoorActivator.LittleDoorActivatorType("doorActivator", "door", LittleDoorActivator.class, 0), LittleDoorActivator.LittleDoorActivatorParser.class);
    }

    public static abstract class LittleDoorBaseParser
    extends LittleStructureGuiParser {
        public LittleDoorBaseParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void onChanged(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"duration_s"}) || event.source.is(new String[]{"children_activate"}) || event.source.is(new String[]{"interpolation"})) {
                this.updateTimeline();
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            boolean stayAnimated;
            boolean bl = stayAnimated = structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).stayAnimated : false;
            boolean disableRightClick = structure instanceof LittleDoor ? !((LittleDoor)structure).disableRightClick : true;
            boolean noClip = structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).noClip : false;
            this.parent.controls.add(new SubGuiDoorSettings.GuiDoorSettingsButton("settings", 108, 93, stayAnimated, disableRightClick, noClip));
            this.parent.controls.add(new GuiLabel(CoreControl.translate((String)"gui.door.duration") + ":", 90, 122));
            this.parent.controls.add(new GuiSteppedSlider("duration_s", 140, 122, 50, 6, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).duration : 50, 1, 500));
            this.parent.controls.add(new SubGuiDoorEvents.GuiDoorEventsButton("children_activate", 93, 107, previews, structure instanceof LittleDoorBase ? (LittleDoorBase)structure : null));
            this.parent.controls.add(new GuiStateButton("interpolation", structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).interpolation : 0, 140, 107, 40, 7, ValueTimeline.interpolationTypes));
            this.updateTimeline();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleDoorBase parseStructure(LittlePreviews previews) {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            SubGuiDoorSettings.GuiDoorSettingsButton settings = (SubGuiDoorSettings.GuiDoorSettingsButton)this.parent.get("settings");
            SubGuiDoorEvents.GuiDoorEventsButton button = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            GuiStateButton interpolationButton = (GuiStateButton)this.parent.get("interpolation");
            int duration = (int)slider.value;
            LittleDoorBase door = this.parseStructure();
            door.duration = duration;
            door.stayAnimated = settings.stayAnimated;
            door.disableRightClick = !settings.disableRightClick;
            door.noClip = settings.noClip;
            door.events = button.events;
            door.interpolation = interpolationButton.getState();
            return door;
        }

        @SideOnly(value=Side.CLIENT)
        public abstract LittleDoorBase parseStructure();

        @SideOnly(value=Side.CLIENT)
        public abstract void populateTimeline(AnimationTimeline var1, int var2);

        public void updateTimeline() {
            GuiSteppedSlider slider = (GuiSteppedSlider)this.parent.get("duration_s");
            AnimationTimeline timeline = new AnimationTimeline((int)slider.value, (PairList<AnimationKey, ValueTimeline>)new PairList());
            SubGuiDoorEvents.GuiDoorEventsButton children = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            GuiStateButton interpolationButton = (GuiStateButton)this.parent.get("interpolation");
            this.populateTimeline(timeline, interpolationButton.getState());
            this.handler.setTimeline(timeline, children.events);
        }
    }

    public static abstract class LittleDoorBaseType
    extends LittleStructureType {
        public LittleDoorBaseType(String id, String category, Class<? extends LittleStructure> structureClass, int attribute) {
            super(id, category, structureClass, attribute);
        }

        public abstract void setBit(LittlePreviews var1, BitSet var2);

        @Override
        public void finializePreview(LittlePreviews previews) {
            List<LittlePreviews> previewChildren = previews.getChildren();
            if (!previewChildren.isEmpty()) {
                BitSet set = new BitSet(previewChildren.size());
                this.setBit(previews, set);
                for (int i = 0; i < previewChildren.size(); ++i) {
                    if (!previewChildren.get(i).hasStructure()) continue;
                    if (set.get(i)) {
                        previewChildren.get((int)i).structure.func_74757_a("activateParent", true);
                        continue;
                    }
                    previewChildren.get((int)i).structure.func_82580_o("activateParent");
                }
            }
        }
    }
}

