/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.signal.ISignalBase;
import com.creativemd.littletiles.common.structure.signal.ISignalInput;
import com.creativemd.littletiles.common.structure.signal.ISignalOutput;
import com.creativemd.littletiles.common.structure.signal.ISignalTransmitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SignalNetwork {
    public final int bandwidth;
    private final boolean[] state;
    private List<ISignalTransmitter> transmitters = new ArrayList<ISignalTransmitter>();
    private List<ISignalInput> inputs = new ArrayList<ISignalInput>();
    private List<ISignalOutput> outputs = new ArrayList<ISignalOutput>();

    public SignalNetwork(int bandwidth) {
        this.bandwidth = bandwidth;
        this.state = new boolean[bandwidth];
    }

    public void update() {
        int i;
        boolean[] oldState = Arrays.copyOf(this.state, this.bandwidth);
        BooleanUtils.reset((boolean[])this.state);
        for (i = 0; i < this.outputs.size(); ++i) {
            BooleanUtils.or((boolean[])this.state, (boolean[])this.outputs.get(i).getState());
        }
        if (!BooleanUtils.equals((boolean[])this.state, (boolean[])oldState) && !this.inputs.isEmpty()) {
            for (i = 0; i < this.inputs.size(); ++i) {
                this.inputs.get(i).setState(this.state);
            }
        }
    }

    public void merge(SignalNetwork network) {
        int i;
        boolean changed2;
        boolean[] oldState = Arrays.copyOf(this.state, this.bandwidth);
        boolean[] oldState2 = Arrays.copyOf(network.state, this.bandwidth);
        int sizeBefore = this.outputs.size();
        for (int i2 = 0; i2 < network.outputs.size(); ++i2) {
            ISignalOutput output = network.outputs.get(i2);
            if (SignalNetwork.containsUntil(this.outputs, output, sizeBefore)) continue;
            BooleanUtils.or((boolean[])this.state, (boolean[])output.getState());
            output.setNetwork(this);
            this.outputs.add(output);
        }
        boolean changed = !BooleanUtils.equals((boolean[])this.state, (boolean[])oldState);
        boolean bl = changed2 = !BooleanUtils.equals((boolean[])this.state, (boolean[])oldState2);
        if (changed && !this.inputs.isEmpty()) {
            for (i = 0; i < this.inputs.size(); ++i) {
                this.inputs.get(i).setState(this.state);
            }
        }
        sizeBefore = this.inputs.size();
        if (!network.inputs.isEmpty()) {
            for (i = 0; i < network.inputs.size(); ++i) {
                ISignalInput input = network.inputs.get(i);
                if (SignalNetwork.containsUntil(this.inputs, input, sizeBefore)) continue;
                input.setNetwork(this);
                if (changed2) {
                    input.setState(this.state);
                }
                this.inputs.add(input);
            }
        }
        sizeBefore = this.transmitters.size();
        if (!network.transmitters.isEmpty()) {
            for (i = 0; i < network.transmitters.size(); ++i) {
                ISignalTransmitter transmitter = network.transmitters.get(i);
                if (SignalNetwork.containsUntil(this.transmitters, transmitter, sizeBefore)) continue;
                transmitter.setNetwork(this);
                this.transmitters.add(transmitter);
            }
        }
    }

    public static <T> boolean containsUntil(List<T> list, T object, int index) {
        for (int i = 0; i < index; ++i) {
            if (list.get(i) != object) continue;
            return true;
        }
        return false;
    }

    public void add(ISignalBase base) {
        if (base.getNetwork() == this) {
            return;
        }
        if (base.hasNetwork()) {
            this.merge(base.getNetwork());
            return;
        }
        base.setNetwork(this);
        switch (base.getType()) {
            case INPUT: {
                this.inputs.add((ISignalInput)base);
                break;
            }
            case OUTPUT: {
                this.outputs.add((ISignalOutput)base);
                break;
            }
            case TRANSMITTER: {
                Iterator<ISignalBase> connections = base.connections();
                while (connections.hasNext()) {
                    this.add(connections.next());
                }
                this.transmitters.add((ISignalTransmitter)base);
            }
        }
    }

    public void deleteNetwork() {
        int i;
        for (i = 0; i < this.inputs.size(); ++i) {
            this.inputs.get(i).setNetwork(null);
        }
        for (i = 0; i < this.outputs.size(); ++i) {
            this.outputs.get(i).setNetwork(null);
        }
        for (i = 0; i < this.transmitters.size(); ++i) {
            this.transmitters.get(i).setNetwork(null);
        }
        this.inputs.clear();
        this.outputs.clear();
        this.transmitters.clear();
    }

    public void remove(ISignalBase base) {
        base.setNetwork(null);
        switch (base.getType()) {
            case INPUT: {
                this.inputs.remove(base);
                break;
            }
            case OUTPUT: {
                this.outputs.remove(base);
                break;
            }
            case TRANSMITTER: {
                this.deleteNetwork();
            }
        }
    }
}

