/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal;

import com.creativemd.littletiles.common.structure.signal.SignalNetwork;
import com.creativemd.littletiles.common.structure.signal.SignalType;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.Iterator;
import net.minecraft.util.EnumFacing;

public interface ISignalBase {
    default public boolean compatible(ISignalBase other) {
        if (other.getType() != SignalType.TRANSMITTER && other.getType() == this.getType()) {
            return false;
        }
        return this.getBandwidth() == other.getBandwidth();
    }

    public int getBandwidth();

    public SignalNetwork getNetwork();

    public void setNetwork(SignalNetwork var1);

    public Iterator<ISignalBase> connections();

    public boolean canConnect(EnumFacing var1);

    public void connect(EnumFacing var1, ISignalBase var2, LittleGridContext var3, int var4);

    public void disconnect(EnumFacing var1, ISignalBase var2);

    public SignalType getType();

    default public boolean hasNetwork() {
        return this.getNetwork() != null;
    }

    default public SignalNetwork findNetwork() {
        if (this.hasNetwork()) {
            return this.getNetwork();
        }
        Iterator<ISignalBase> connections = this.connections();
        while (connections.hasNext()) {
            ISignalBase connection = connections.next();
            if (!connection.hasNetwork()) continue;
            connection.getNetwork().add(this);
            return this.getNetwork();
        }
        SignalNetwork network = new SignalNetwork(this.getBandwidth());
        network.add(this);
        return this.getNetwork();
    }
}

