/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.relative;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviewRelative;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class StructureRelative
implements IGridBased {
    protected LittleGridContext context;
    protected LittleBox box;

    public StructureRelative(LittleBox box, LittleGridContext context) {
        this.box = box;
        this.context = context;
    }

    public StructureRelative(int[] array) {
        this.box = new LittleBox(array[0], array[1], array[2], array[3], array[4], array[5]);
        this.context = LittleGridContext.get(array[6]);
    }

    public LittleVec getDoubledCenterVec() {
        return new LittleVec(this.box.maxX + this.box.minX, this.box.maxY + this.box.minY, this.box.maxZ + this.box.minZ);
    }

    public Vector3d getCenter() {
        return new Vector3d(this.context.toVanillaGrid(this.box.maxX + this.box.minX) / 2.0, this.context.toVanillaGrid(this.box.maxY + this.box.minY) / 2.0, this.context.toVanillaGrid(this.box.maxZ + this.box.minZ) / 2.0);
    }

    public boolean isEven() {
        return this.box.getSize(EnumFacing.Axis.X) > 1;
    }

    public LittleBox getBox() {
        return this.box;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext context) {
        this.box.convertTo(this.context, context);
        this.context = context;
    }

    @Override
    public void convertToSmallest() {
        int grid = this.box.getSmallestContext(this.context);
        if (grid < this.context.size) {
            this.convertTo(LittleGridContext.get(grid));
        }
    }

    public int[] write() {
        return new int[]{this.box.minX, this.box.minY, this.box.minZ, this.box.maxX, this.box.maxY, this.box.maxZ, this.context.size};
    }

    public void setBox(BlockPos pos, LittleBox box, LittleGridContext context) {
        this.box = box;
        this.context = context;
        this.add(pos);
    }

    public LittleVecContext getMinVec() {
        return new LittleVecContext(this.box.getMinVec(), this.context);
    }

    public PlacePreview getPlacePreview(LittlePreviews previews, StructureDirectionalField type) {
        return new PlacePreviewRelative(this.box, this, type);
    }

    public void move(LittleGridContext context, LittleVec offset) {
        int scale = 1;
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            scale = this.context.size / context.size;
        }
        this.box.add(offset.x * scale, offset.y * scale, offset.z * scale);
        this.convertToSmallest();
    }

    public void flip(LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(context, this.context);
        }
        this.box.flipBox(axis, doubledCenter);
        this.convertToSmallest();
    }

    public void rotate(LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            doubledCenter = doubledCenter.copy();
            doubledCenter.convertTo(context, this.context);
        }
        this.box.rotateBox(rotation, doubledCenter);
        this.convertToSmallest();
    }

    public BlockPos getOffset() {
        return this.box.getMinVec().getBlockPos(this.context);
    }

    public void add(BlockPos pos) {
        this.box.add(new LittleVec(this.context, (Vec3i)pos));
    }

    public void add(LittleVecContext contextVec) {
        int scale = 1;
        if (contextVec.getContext().size > this.context.size) {
            this.convertTo(contextVec.getContext());
        } else if (contextVec.getContext().size < this.context.size) {
            scale = this.context.size / contextVec.getContext().size;
        }
        this.box.add(contextVec.getVec().x * scale, contextVec.getVec().y * scale, contextVec.getVec().z * scale);
        this.convertToSmallest();
    }

    public void sub(BlockPos pos) {
        this.box.sub(new LittleVec(this.context, (Vec3i)pos));
    }

    public void sub(LittleVecContext contextVec) {
        int scale = 1;
        if (contextVec.getContext().size > this.context.size) {
            this.convertTo(contextVec.getContext());
        } else if (contextVec.getContext().size < this.context.size) {
            scale = this.context.size / contextVec.getContext().size;
        }
        this.box.sub(contextVec.getVec().x * scale, contextVec.getVec().y * scale, contextVec.getVec().z * scale);
        this.convertToSmallest();
    }
}

