/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.animation;

import com.creativemd.creativecore.common.utils.math.interpolation.HermiteInterpolation;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.animation.AnimationKey;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ValueTimeline {
    private static List<Class<? extends ValueTimeline>> valueTimelineTypes = new ArrayList<Class<? extends ValueTimeline>>();
    public static String[] interpolationTypes = new String[]{"linear", "cosine", "cubic", "hermite"};
    protected PairList<Integer, Double> points = new PairList();

    public static void registerValueTimelineType(Class<? extends ValueTimeline> type) {
        valueTimelineTypes.add(type);
    }

    public static Class<? extends ValueTimeline> getType(int id) {
        if (id < -1 || id >= valueTimelineTypes.size()) {
            throw new RuntimeException("Invalid id " + id);
        }
        return valueTimelineTypes.get(id);
    }

    public static int getId(Class<? extends ValueTimeline> type) {
        int index = valueTimelineTypes.indexOf(type);
        if (index == -1) {
            throw new RuntimeException("Invalid type " + type.getName());
        }
        return index;
    }

    public static ValueTimeline read(int[] array) {
        if (array.length < 2) {
            throw new RuntimeException("Invalid array size=" + array.length);
        }
        Class<? extends ValueTimeline> type = ValueTimeline.getType(array[0]);
        try {
            ValueTimeline timeline = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            int points = array[1];
            for (int i = 0; i < points; ++i) {
                timeline.points.add((Object)array[2 + i * 3], (Object)Double.longBitsToDouble((long)array[3 + i * 3] << 32 | (long)array[4 + i * 3] & 0xFFFFFFFFL));
            }
            timeline.readAdditionalData(array, 2 + points * 3);
            return timeline;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ValueTimeline create(int id) {
        try {
            return ValueTimeline.getType(id).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static ValueTimeline create(int id, PairList<Integer, ?> points) {
        if (points == null) {
            return null;
        }
        try {
            ValueTimeline timeline = ValueTimeline.getType(id).getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Pair pair : points) {
                double value = pair.value instanceof Integer ? (double)((Integer)pair.value).intValue() : (Double)pair.value;
                timeline.addPoint((Integer)pair.key, value);
            }
            return timeline;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public PairList<Integer, Double> getPointsCopy() {
        return new PairList(this.points);
    }

    public PairList<Integer, Integer> getRoundedPointsCopy() {
        PairList newPoints = new PairList();
        for (Pair pair : this.points) {
            newPoints.add(pair.key, (Object)((int)((Double)pair.value).doubleValue()));
        }
        return newPoints;
    }

    public ValueTimeline addPoints(PairList<Integer, Double> points) {
        for (Pair point : points) {
            this.addPoint((Integer)point.key, (Double)point.value);
        }
        return this;
    }

    public ValueTimeline addPoint(Integer tick, Double value) {
        for (int i = 0; i < this.points.size(); ++i) {
            if ((Integer)((Pair)this.points.get((int)i)).key <= tick) continue;
            this.points.add(i, new Pair((Object)tick, (Object)value));
            return this;
        }
        this.points.add((Object)tick, (Object)value);
        return this;
    }

    public ValueTimeline factor(double factor) {
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            Pair point;
            Pair pair = point = (Pair)iterator.next();
            Double.valueOf((Double)pair.value * factor);
            pair.value = pair.value;
        }
        return this;
    }

    public double value(int tick) {
        if (tick < 0) {
            return 0.0;
        }
        int higher = this.points.size();
        for (int i = 0; i < this.points.size(); ++i) {
            int otherTick = (Integer)((Pair)this.points.get((int)i)).key;
            if (otherTick == tick) {
                return (Double)((Pair)this.points.get((int)i)).value;
            }
            if (otherTick <= tick) continue;
            higher = i;
            break;
        }
        if (higher == 0 || higher == this.points.size()) {
            return (Double)((Pair)this.points.get((int)(higher == 0 ? 0 : this.points.size() - 1))).value;
        }
        Pair before = (Pair)this.points.get(higher - 1);
        Pair after = (Pair)this.points.get(higher);
        double percentage = (double)(tick - (Integer)before.key) / (double)((Integer)after.key - (Integer)before.key);
        return this.valueAt(percentage, (Pair<Integer, Double>)before, higher - 1, (Pair<Integer, Double>)after, higher);
    }

    public abstract double valueAt(double var1, Pair<Integer, Double> var3, int var4, Pair<Integer, Double> var5, int var6);

    public double first(AnimationKey key) {
        if (this.points.isEmpty()) {
            return key.getDefault();
        }
        return (Double)this.points.getFirst().value;
    }

    public double last(AnimationKey key) {
        if (this.points.isEmpty()) {
            return key.getDefault();
        }
        return (Double)this.points.getLast().value;
    }

    public int[] write() {
        int[] data = new int[2 + this.points.size() * 3 + this.getAdditionalDataSize()];
        data[0] = ValueTimeline.getId(this.getClass());
        data[1] = this.points.size();
        for (int i = 0; i < this.points.size(); ++i) {
            Pair pair = (Pair)this.points.get(i);
            data[i * 3 + 2] = (Integer)pair.key;
            long point = Double.doubleToLongBits((Double)pair.value);
            data[i * 3 + 3] = (int)(point >> 32);
            data[i * 3 + 4] = (int)point;
        }
        this.writeAdditionalData(data, 2 + this.points.size() * 3);
        return data;
    }

    protected abstract int getAdditionalDataSize();

    protected abstract void writeAdditionalData(int[] var1, int var2);

    protected abstract void readAdditionalData(int[] var1, int var2);

    protected void invertData(ValueTimeline original) {
    }

    public ValueTimeline copy() {
        return ValueTimeline.read(this.write());
    }

    public void flip() {
        for (Pair pair : this.points) {
            pair.value = -((Double)pair.value).doubleValue();
        }
    }

    public ValueTimeline invert(int duration) {
        try {
            ValueTimeline timeline = (ValueTimeline)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            for (int i = this.points.size() - 1; i >= 0; --i) {
                Pair pair = (Pair)this.points.get(i);
                timeline.addPoint(duration - (Integer)pair.key, (Double)pair.value);
            }
            timeline.invertData(this);
            return timeline;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void offset(int offset) {
        PairList newPoints = new PairList();
        for (Pair point : this.points) {
            newPoints.add((Object)((Integer)point.key + offset), point.value);
        }
        this.points = newPoints;
    }

    static {
        ValueTimeline.registerValueTimelineType(LinearTimeline.class);
        ValueTimeline.registerValueTimelineType(CosineTimeline.class);
        ValueTimeline.registerValueTimelineType(CubicTimeline.class);
        ValueTimeline.registerValueTimelineType(HermiteTimeline.class);
    }

    public static class HermiteTimeline
    extends AdvancedValueTimeline {
        public HermiteInterpolation.Tension tension = HermiteInterpolation.Tension.Normal;
        public double bias = 0.0;

        @Override
        public double valueAt(double mu, Pair<Integer, Double> before, int pointIndex, Pair<Integer, Double> after, int pointIndexNext) {
            double v0 = this.getValue(pointIndex - 1);
            double v1 = this.getValue(pointIndex);
            double v2 = this.getValue(pointIndexNext);
            double v3 = this.getValue(pointIndexNext + 1);
            double mu2 = mu * mu;
            double mu3 = mu2 * mu;
            double m0 = (v1 - v0) * (1.0 + this.bias) * (double)(1 - this.tension.value) / 2.0;
            m0 += (v2 - v1) * (1.0 - this.bias) * (double)(1 - this.tension.value) / 2.0;
            double m1 = (v2 - v1) * (1.0 + this.bias) * (double)(1 - this.tension.value) / 2.0;
            double a0 = 2.0 * mu3 - 3.0 * mu2 + 1.0;
            double a1 = mu3 - 2.0 * mu2 + mu;
            double a2 = mu3 - mu2;
            double a3 = -2.0 * mu3 + 3.0 * mu2;
            return a0 * v1 + a1 * m0 + a2 * (m1 += (v3 - v2) * (1.0 - this.bias) * (double)(1 - this.tension.value) / 2.0) + a3 * v2;
        }

        @Override
        protected int getAdditionalDataSize() {
            return 3;
        }

        @Override
        protected void writeAdditionalData(int[] array, int index) {
            array[index] = this.tension.ordinal();
            long bits = Double.doubleToLongBits(this.bias);
            array[index + 1] = (int)(bits >> 32);
            array[index + 2] = (int)bits;
        }

        @Override
        protected void readAdditionalData(int[] array, int index) {
            this.tension = HermiteInterpolation.Tension.values()[array[index]];
            this.bias = Double.longBitsToDouble((long)array[index + 1] << 32 | (long)array[index + 2] & 0xFFFFFFFFL);
        }
    }

    public static class CubicTimeline
    extends AdvancedValueTimeline {
        @Override
        public double valueAt(double mu, Pair<Integer, Double> before, int pointIndex, Pair<Integer, Double> after, int pointIndexNext) {
            double v0 = this.getValue(pointIndex - 1);
            double v1 = this.getValue(pointIndex);
            double v2 = this.getValue(pointIndexNext);
            double v3 = this.getValue(pointIndexNext + 1);
            double mu2 = mu * mu;
            double a0 = v3 - v2 - v0 + v1;
            double a1 = v0 - v1 - a0;
            double a2 = v2 - v0;
            double a3 = v1;
            return a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3;
        }

        @Override
        protected int getAdditionalDataSize() {
            return 0;
        }

        @Override
        protected void writeAdditionalData(int[] array, int index) {
        }

        @Override
        protected void readAdditionalData(int[] array, int index) {
        }
    }

    public static abstract class AdvancedValueTimeline
    extends ValueTimeline {
        protected double getValue(int index) {
            if (index < 0) {
                return (Double)this.points.getFirst().getValue();
            }
            if (index >= this.points.size()) {
                return (Double)this.points.getLast().getValue();
            }
            return (Double)((Pair)this.points.get(index)).getValue();
        }
    }

    public static class CosineTimeline
    extends ValueTimeline {
        @Override
        protected int getAdditionalDataSize() {
            return 0;
        }

        @Override
        protected void writeAdditionalData(int[] array, int index) {
        }

        @Override
        protected void readAdditionalData(int[] array, int index) {
        }

        @Override
        public double valueAt(double mu, Pair<Integer, Double> before, int pointIndex, Pair<Integer, Double> after, int pointIndexNext) {
            double mu2 = (1.0 - Math.cos(mu * Math.PI)) / 2.0;
            return (Double)before.value * (1.0 - mu2) + (Double)after.value * mu2;
        }
    }

    public static class LinearTimeline
    extends ValueTimeline {
        @Override
        public double valueAt(double mu, Pair<Integer, Double> before, int pointIndex, Pair<Integer, Double> after, int pointIndexNext) {
            return ((Double)after.value - (Double)before.value) * mu + (Double)before.value;
        }

        @Override
        protected int getAdditionalDataSize() {
            return 0;
        }

        @Override
        protected void writeAdditionalData(int[] array, int index) {
        }

        @Override
        protected void readAdditionalData(int[] array, int index) {
        }
    }
}

