/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierAbsolute;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class LittlePlacedAnimationPacket
extends CreativeCorePacket {
    public UUID worldUUID;
    public LittleIdentifierAbsolute identifier;
    public UUID previousAnimation;

    public LittlePlacedAnimationPacket(LittleTile tile, UUID previousAnimation) {
        this.previousAnimation = previousAnimation;
        this.identifier = new LittleIdentifierAbsolute(tile);
        if (tile.te.func_145831_w() instanceof CreativeWorld) {
            this.worldUUID = ((CreativeWorld)tile.te.func_145831_w()).parent.func_110124_au();
        }
    }

    public LittlePlacedAnimationPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittlePlacedAnimationPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.identifier.writeToNBT(new NBTTagCompound()));
        LittlePlacedAnimationPacket.writeString((ByteBuf)buf, (String)this.previousAnimation.toString());
        if (this.worldUUID != null) {
            buf.writeBoolean(true);
            LittlePlacedAnimationPacket.writeString((ByteBuf)buf, (String)this.worldUUID.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.identifier = new LittleIdentifierAbsolute(LittlePlacedAnimationPacket.readNBT((ByteBuf)buf));
        this.previousAnimation = UUID.fromString(LittlePlacedAnimationPacket.readString((ByteBuf)buf));
        this.worldUUID = buf.readBoolean() ? UUID.fromString(LittlePlacedAnimationPacket.readString((ByteBuf)buf)) : null;
    }

    public void executeClient(EntityPlayer player) {
        block5: {
            World world = player.field_70170_p;
            if (this.worldUUID != null) {
                EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.worldUUID);
                if (animation == null) {
                    return;
                }
                world = animation.fakeWorld;
            }
            try {
                LittleTile tile = LittleAction.getTile(world, this.identifier);
                if (tile.isChildOfStructure() && tile.connection.getStructure(world) instanceof LittleDoor) {
                    ((LittleDoor)tile.connection.getStructureWithoutLoading()).waitingForApproval = false;
                }
            }
            catch (LittleActionException e) {
                EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.previousAnimation);
                if (animation == null || animation.controller == null) break block5;
                animation.controller.onServerPlaces();
            }
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

